#include "treelist.h"
#include "../webtree.h"

TreeList::TreeList(Document *d, QWidget *parent, const char *name)
  : KTreeList(parent, name)
{
  doc = d;
  setExpandLevel(4);
}

TreeList::~TreeList()
{
}

// add node to treelist. this is called by the html-engine after a new node has
// been created
void TreeList::addNode(TreeInfo *ti)
{

  // calculate in which line the new node will appear. this is needed for
  // KTreeList

  // find the father of the current node.

  index = 0;
  haveIt = FALSE;
  insertItems = FALSE;
  dive(doc->html.root, ti->father, index);

  // insert it into tree
  insertTreeInfo(index, ti);

  // we now must check for children of the added node because if they were
  // loaded previously we dont't get informed twice

  // find the current node (if father is valid)

/*  if(ti->father)
  {
    haveIt = FALSE;
    dive(ti->father, ti, index);

    // insert child items

    haveIt = FALSE;
    insertItems = TRUE;
    dive(ti, NULL, index);
  }*/
}

// recursive function to determine the index of a treeinfo item. this is needed
// for the treelist-widget to get the line number after which this item gets
// inserted
void TreeList::dive(TreeInfo *current, TreeInfo *target, int lastFatherIndex)
{
  TreeInfo *child;
  NextTreeInfo *next_ti, *nt_check;
  bool alreadyRef;
  
//  debug("            diving: %s", current->title);

  if( (current == target) || (target == NULL) )
  {
    haveIt = TRUE;
    return;
  }

  next_ti = current->nextTree;

  while(next_ti)
  {
    child = next_ti->tree;

    // check if already referenced in this treeinfo to avoid double entries
    // and wrong indexes
    alreadyRef = FALSE;
    nt_check = current->nextTree;
    while(nt_check != next_ti)
    {
      if(nt_check->tree == child)
      {
	alreadyRef = TRUE;
	break;
      }
      nt_check = nt_check->next;
    }

    if( (!alreadyRef) && (child->loaded) && (child->depth > current->depth) &&
	(child->father == current) ) // check also that I am the father of the child!
    {
      index++;
      if(insertItems)
      {
//	debug("             inserting %s after [%d]", child->title, lastFatherIndex);
	insertTreeInfo(lastFatherIndex, child);
      }
      dive(child, target, index);
      if(haveIt)
	return;
    }
    next_ti = next_ti->next;
  }
}

void TreeList::insertTreeInfo( int , TreeInfo *ti )
{
  QPixmap *pix;

  switch(ti->doctype)
  {
    case HTMLDoc:
    case TextFile:
      pix = ::treeHtmlDoc;
      break;
    case PackedFile:
      pix = ::treeCompDoc;
      break;
    case Graphic:
      pix = ::treePicDoc;
      break;
    case Unknown:
    default:
      pix = ::treeOtherDoc;
      break;
  }

  // now add the item to the treelist

  if(ti->father)
    addChildItem((const char*)&(ti->title), pix, index);
  else
    insertItem((const char*)&(ti->title), pix, 0);
}


