#define PATHLENGTH 200

/* these views are available */
enum Viewtype { topdownview, leftrightview, browserview };

/* these contents can be displayed */
enum Nodecontent { title = 0x0, url = 0x2 };

/* include and excludelist are lists of domainnames */
struct Searchlist
{
  char domain[PATHLENGTH];
  struct Searchlist *next;
};

struct Pref
{
  char mirrorpath [PATHLENGTH];          /* where to store local files */
  int mirrorsizemax;                     /* maximum size of mirror */
  int mirrorhttp;                        /* store HTML documents */
  int mirrorpic;                         /* store PICTURES (gif, jpeg) */
  int mirrorother;                       /* store OTHER documents */
                                         /* text files, packed files.. */

  char http_proxy [PATHLENGTH];          /* name for proxy */
  int http_timeout;                      /* Timeout for HTTP module */
  int http_threadsmax;                   /* amount of threads executed */

  int searchdepth;                       /* maximum depth of WebTree */
  int searchinclude;                     /* chooses between searchinclude */
                                         /* and -excludelist */ 
  struct Searchlist *searchincludelist;  /* specify every domain to be */
                                         /* used */
  struct Searchlist *searchexcludelist;  /* specify every domain not to */
                                         /* be used */ 

  enum Viewtype viewtype;                /* select view to be displayed */
  enum Nodecontent nodecontent;          /* select nodecontent to be */
                                         /* displayed */
  int viewfontsizedefault;               /* default font size */
  int viewfontsizemin;                   /* minimum font size */
  int viewshowordered;                   /* TRUE = display also ordered Docs */
                                         /* FALSE= display only arrived Docs */
};


