/* Structures needed by Layout module */

#define UNUSED        0x0         /* this link is unused - don't or this def */
#define USED          0x1         /* this link is in use - for duplicates */
#define DIRECT        0x2         /* this link is a direct one */
#define BACKANDFORTH  0x4         /* this link goes back and forth */

#define LINEMAX       4

struct layout_TreeInfo
{
  int draw;                       /* always check this first if node
				     should be drawn (1) or not (0) */
  int collapsed;		  /* used for collapse/expand node */
  int x, y, width, height;        /* for LAYOUT */
  int vpos, vsize;                /* for LAYOUT */
  int fontsize;                   /* for LAYOUT */
  int visited,moved;              /* for LAYOUT */
  int linksin;                    /* count of links that point to this page */
  int linksout;                   /* count of links that point from the page */
  int directlinksout;             /* count of direct links from the page */
  int visiblelinksout;            /* count of visible links from this page */
  char text[ NAME_MAXLEN ];       /* text to display in LAYOUT */
};

struct layout_NextTreeInfo
{
  int type;                     /* type of link, see defines */
  int nr;                       /* nr of link */
  int x[LINEMAX];               /* Position of link */
  int y[LINEMAX];
};


