#ifndef _LAYOUT_H
#define _LAYOUT_H

/* Constants for the layout */
#define MINHDIST 20           /* minimal distance between two boxes in top-down-view */
#define MINVDIST 20           /* minimal distance between two boxes in left-right-view */
#define DISTTOBORDER 40       /* minimal distance to the border */
#define MAXBOXWIDTH 120  
#define MINBOXWIDTH 60       

#define MAXPATH 200           /* maximum path length - that's the way from the root
				 to the last leaf */

#define GRIDDY  100           /* distance between two gridlines in vertical order */
#define GRIDDX  200           /* distance between two gridlines in vertical order */

struct GridBox
{
  struct TreeInfo *parent;
  struct GridBox *nextGrid;
  int pos,size;            /* pos of gridbox and space allocated to node */
};

#define MAXGRIDLINES 200

struct Layout
{
  int maxw,maxh;
  struct GridBox *grid[MAXGRIDLINES];
};

/**********************************************************************/
/* start of public interface                                          */
/**********************************************************************/
extern void layout_init();
/* call to initialize layout in current context - don`t forget to call*/
/* for each context                                                   */

extern void layout_nodeAdded(struct TreeInfo *node);
/* call to calculate coordinates for new node and reposition old ones */

extern void layout_recalcAll();
  /* call after changes to the viewtype, the nodecontent, the fontsize, ..
     in order to recalc the size and position of the boxes and all links,
     call it even if a node is deleted from the tree, or you stopped
     loading a node */

/* please call these function when allocating or deallocating TreeInfo or */
/* NextTreeInfo structures */
extern void layout_initTreeInfo(struct TreeInfo *ti);
extern void layout_freeTreeInfo(struct TreeInfo *ti);
extern void layout_initNextTreeInfo(struct NextTreeInfo *nti);
extern void layout_freeNextTreeInfo(struct NextTreeInfo *nti);
/* call this function only when deallocation a NextTreeInfo structure that
   resides NOT in the fatherlist */

extern void layout_collapseNode( struct TreeInfo *node );
/* collapses a subtree */

extern void layout_expandNode( struct TreeInfo *node );
/* expands a subtree */

/**********************************************************************/
/* end of public interface                                            */
/**********************************************************************/

#endif


