/* sget.c
   PURPOSE: test my http.c */

#include "../document.h"
#include <stdio.h>
#include <stdlib.h>

#include <stdarg.h> 
int debug_level = 7;

void dbg( int l,  char *fn, char *m, int dblvl, char *msg, ...)
{
  char buf[300];

  if( (dblvl & 3) <= (debug_level & 3) &&
      ((dblvl & 124) == (debug_level & 124)) )
  {
    va_list pa;
    va_start( pa, msg );
    fprintf( stderr, "%s:%d:(%s) - ", m, l, fn );
    vfprintf( stderr, msg, pa );
    fprintf( stderr, "\n" );
    va_end( pa );
  }
}


struct Document *context;

int main(int argc, char** argv)
{
int i;
struct Results* res = NULL;

http_glob_init();

/* Construct a context!! */
context = malloc(sizeof(struct Document));
http_initialize();
context->pref.http_threadsmax=3;
/* strcpy(context->pref.http_proxy,"proxy.tuwien.ac.at:8000"); */
context->pref.http_proxy[0]=0;    /* to disable proxy feature!*/

/* place some orders. */
for(i=1;i<argc;i++)
  {
    if(res==NULL) res = http_order(argv[i]);
    else http_order(argv[i]);
  }

/* now, abort the first request! */
/* http_abort(res); */

/* wait for the results */
while( (res=http_waitNext()) !=NULL) 
/* sleep(1);
   while((res = http_getNext()) != NULL) */
  {
    printf(" status: %d, size: %d \n",
	   res->status,res->size);
    if(res->size != 0) printf(res->text);

    http_free(res);   /* never forget to call free!! */
  }

http_glob_finalize();

printf("done.\n");
return 0;
}
 










