#include <sys/types.h>
#include <sys/time.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <unistd.h>
struct Document;

/**********************************************************************/
/* begin of public interface                                          */
/**********************************************************************/

#define BSIZE 2048    /* Buffersize for known-size answers (static)*/
#define GSIZE 8192    /* Min buffersize for sizless answers (dynamic)*/

struct Results
{ 
char *url;        /* URL */
int status;       /* Status (check this, before accesing text */
char* text;       /* received data */
int size;         /* size of data chunk */
char mimetype[40]; /* Mimetype, if supplied by server */
  /* The following attributes are only for internal use! */
int left;
int fd;
char* inpos;
struct sockaddr_in sa;
enum {HI_postponed,HI_starting,
      HI_WFGetHostName, HI_WFConnect, HI_WFHeader, HI_WFHeader2, 
      HI_WFDataS,HI_WFDataSl,
      HI_ready} istate;
struct Results* next;
};

/* where status can be:
   -10   unknown protocoll (url should start with http:// or file:/)
   -11   can not resolv hostname
   -12   can not create a socket
   -13   can not connect to remote host ( no http server running there? )
   -14   realloc failed, bailing out!!!!!!!!!!
   -16   connection interrupted!
   -17   file not found
   -18   error while loading file
 any positive values are return values from the http server!
 the following is taken from the rfc1945.txt (HTTP/1.0)
     "200"   ; OK                                            
   | "201"   ; Created                                       
   | "202"   ; Accepted                                      
   | "204"   ; No Content                                    
   | "301"   ; Moved Permanently                             
   | "302"   ; Moved Temporarily                             
   | "304"   ; Not Modified                                  
   | "400"   ; Bad Request                                   
   | "401"   ; Unauthorized                                  
   | "403"   ; Forbidden                                     
   | "404"   ; Not Found                                     
   | "500"   ; Internal Server Error                         
   | "501"   ; Not Implemented                               
   | "502"   ; Bad Gateway                                   
   | "503"   ; Service Unavailable           

   */


extern int http_glob_init();
/* Call this only once per Programm!
   It is used to creaty the DNS-lookup client process
*/

extern void http_glob_finalize();
/* Call this only once per Programm!
   It will destry the DNS-lookup client 
*/


extern int http_initialize();
/* call this before to initialize the context data of the http module 
   Return Value:
     0  ... success
     -1 ... can not initialize mutex!!  can not continue!!!!!
*/

extern int http_finalize();
/* Call this to destroy this http context!
   1 ..... success, you can free now the memory of the context
   0 ..... failed, sice some threads are still active
   */


extern struct Results* http_order(char* );
/*   
   PURPOSE:
     Call this funcion to order a document, reffered by the given URL.
   RETURN value:
     getUrl returns immediatly an unique address, wich identifies the
     request!
  ERRORS
     if 0 is returned, pthread_created failed!
*/
extern struct Results* http_orderQuick(char* );
/* The same as http_order, but this request overtakes all delayed requests */

extern struct Results* http_getNext();
extern struct Results* http_waitNext();
/* Use one of these functions the get the data,
   while waitNextUrl blocks until the next document is available,
   return getNextUrl immediatle if nothing is available right now. */

extern void http_free(struct Results* );
/* After processing, you should always free the Results sturcture with 
   this function */

extern void http_abort(struct Results* );
/* Use the return value of an oderUrl Call to canel a request! */


extern int http_numberOfThreads();
extern int http_numberOfPostponed();
/* These two functions returns the numer of active connections and the
   number of postponed requests! */

extern void http_abortAll();
/* This function cancels all requests (running and postponed) */

extern void http_schedule(int);
/* this function should be called periodical...
   but it is called from http_getNext() and http_waitNext() anyway,
   so if you periodical call one of these functions you need not to
   worry abaout http_schedule. 
  
   http_schedule(0); is non-blocking!
   http_schedule(1); is blocking! (only use this, if you know what you are 
                     doing!!!!!!!)
*/

extern int http_finished();
/* this function returns 1 no more calls to http_getNext() are necessary,
                         0 if you should call http_getNext() */

/**********************************************************************/
/* end of public interface                                            */
/**********************************************************************/

struct Http
{
fd_set wfdset;
fd_set rfdset;
int sel_n;
int threads;
int delayed;
struct Results* firstRun;
struct Results* firstPost;
struct Results* lastPost;
struct Results* firstReady;
struct Results* lastReady;  
};






