#include <string.h>

#include "../document.h"
#include "html_priv.h"

struct struct_httperr
{
  int value;
  char *text;
};

struct struct_httperr HttpError[] =
{
  { -10, "Unknown protocoll (url should start with http:// or file:/)" } ,
  { -11, "Cannot resolv hostname" } ,
  { -12, "Cannot create a socket" } ,
  { -13, "Cannot connect to remote host (no http server running there?)" } ,
  { -14, "Realloc failed, bailing out" } ,
  { -16, "Connection interrupted!" } ,
  { -17, "File not found" } ,
  { -18, "Error while loading file" } ,
  { -21, "Cannot open file" } ,
  { -22, "Cannot read file" } ,
  { -23, "Aborted" } ,
/*  { 200, "OK" } ,*/
  { 201, "Created" } ,
  { 202, "Accepted" } ,
  { 204, "No Content" } ,
  { 301, "Moved Permanently" } ,
  { 302, "Moved Temporarily" } ,
  { 304, "Not Modified" } ,
  { 400, "Bad Request" } ,
  { 401, "Unauthorized" } ,
  { 403, "Forbidden" } ,
  { 404, "Not Found" } ,
  { 500, "Internal Server Error" } ,
  { 501, "Not Implemented" } ,
  { 502, "Bad Gateway" } ,
  { 503, "Service Unavailable" } ,
  {   0, NULL } ,
};


struct ampseq_s 
{
  char *tag;
  char value;
};

struct ampseq_s AmpSequences[] = 
{
  { "lt", '<' } ,		
  { "LT", '<' } ,
  { "gt", '>' } ,
  { "GT", '>' } ,
  { "amp", '&' } ,
  { "AMP", '&' } ,
  { "quot", '\"' } ,
  { "QUOT", '\"' } ,
  { "Agrave", '\300' } ,
  { "Aacute", '\301' } ,
  { "Acirc", '\302' } ,
  { "Atilde", '\303' } ,
  { "Auml", '\304' } ,
  { "Aring", '\305' } ,
  { "AElig", '\306' } ,
  { "Ccedil", '\307' } ,
  { "Egrave", '\310' } ,
  { "Eacute", '\311' } ,
  { "Ecirc", '\312' } ,
  { "Euml", '\313' } ,
  { "Igrave", '\314' } ,
  { "Iacute", '\315' } ,
  { "Icirc", '\316' } ,
  { "Iuml", '\317' } ,
  { "ETH", '\320' } ,
  { "Ntilde", '\321' } ,
  { "Ograve", '\322' } ,
  { "Oacute", '\323' } ,
  { "Ocirc", '\324' } ,
  { "Otilde", '\325' } ,
  { "Ouml", '\326' } ,
  { "Oslash", '\330' } ,
  { "Ugrave", '\331' } ,
  { "Uacute", '\332' } ,
  { "Ucirc", '\333' } ,
  { "Uuml", '\334' } ,
  { "Yacute", '\335' } ,
  { "THORN", '\336' } ,
  { "szlig", '\337' } ,
  { "agrave", '\340' } ,
  { "aacute", '\341' } ,
  { "acirc", '\342' } ,
  { "atilde", '\343' } ,
  { "auml", '\344' } ,
  { "aring", '\345' } ,
  { "aelig", '\346' } ,
  { "ccedil", '\347' } ,
  { "egrave", '\350' } ,
  { "eacute", '\351' } ,
  { "ecirc", '\352' } ,
  { "euml", '\353' } ,
  { "igrave", '\354' } ,
  { "iacute", '\355' } ,
  { "icirc", '\356' } ,
  { "iuml", '\357' } ,
  { "eth", '\360' } ,
  { "ntilde", '\361' } ,
  { "ograve", '\362' } ,
  { "oacute", '\363' } ,
  { "ocirc", '\364' } ,
  { "otilde", '\365' } ,
  { "ouml", '\366' } ,
  { "oslash", '\370' } ,
  { "ugrave", '\371' } ,
  { "uacute", '\372' } ,
  { "ucirc", '\373' } ,
  { "uuml", '\374' } ,
  { "yacute", '\375' } ,
  { "thorn", '\376' } ,
  { "yuml", '\377' } ,
  { "copy", '\251' } ,
  { "reg", '\256' } ,
  { "nbsp", ' ' } ,
  { NULL, '\0' }         /* end character - do not delete */
};


char *htmlErrorString( int c )
{
  int i;
  for( i = 0; HttpError[i].value && HttpError[i].text; i++ )
    if( HttpError[i].value == c )
      return HttpError[i].text;

  return "Unknown error ?!";
}

/*
  substitute all special characters to human readable ones in a
  given string
  e.g. converts &Uuml;berflu&slig; to berflu ... 

  returns pointer to converted text
*/

const char *substituteSpecialChars( const char *t )
{
  int dbuf = FALSE;
  int l, l2, i;
  char *u = (char*)t, *h;

  if( t == BUF )
  {
    dbuf = TRUE;
    u = strdup( (const char*)t );
  }
  
  BUF[0] = '\0';

  if( dbuf )
    free( u );

  while( ( h = strchr( (const char*)u, '&' ) ) != NULL )
  {
    strncat( BUF, (const char*)u, (int)(h - u) );
    h++;
    u = h;
    for( i = 0; AmpSequences[i].tag ; i++ )
      if( strncmp( h, (const char*)AmpSequences[i].tag, ( l2 = strlen(AmpSequences[i].tag) ) ) == 0 )
      {
	if( h[l2] == ';' )
	{
	  l = strlen( BUF );
	  BUF[l] = AmpSequences[i].value;
	  BUF[l+1] = '\0';
	  u = h + l2;
	  if( h[l2] != '\0' )
	    u++;
	  break;
	}
      }
  }
  strcat( BUF, u );

  if( dbuf )
    free( u );

  return BUF;
}
