#ifndef _HTML_PRIV_H

#include "html.h"
#include <stdlib.h>
#include <stdio.h>

/* some handy defines for lazy writing... */

#define TI struct TreeInfo
#define NTI struct NextTreeInfo
#define PL struct PicList
#define R struct Results
#define SL struct Searchlist
#define ER struct ExtReq

#define CH (context->html)
#define CP (context->pref)

/* a little global buffer */
extern char html_buffer[];
#define BUF (html_buffer)

#define MIRROR_ENABLED ( CP.mirrorhttp || CP.mirrorpic || CP.mirrorother )

/* service definitions */

#define SERVICE_NONE    0
#define SERVICE_HTTP	1
#define SERVICE_FILE    2
#define SERVICE_MAILTO  3
#define SERVICE_FTP     4
#define SERVICE_GOPHER  5

/* parser flags */

#define PARSER_MAKERELATIVE 1
#define PARSER_MAKEABSOLUTE 2

/* Main*/

PL *createPicEntry( const char *url );
PL *picInMem( const char *url );
PL *addPicEntry( const char *url );
TI *createNode( TI *father, const char *url );
int addNode( TI *father, const char *url );
void deleteNode( TI *node, TI *loopNode, int mode );
void startOrStopRecursive( TI *node, int start, int first );

/* HTML Helper */

const char *strlostr(const char *string, const char *sub);
TI *nodeInMem( const char *url );
const char *domainOfUrl( const char *url );
int inexPassed( const char *url );
void deleteNode( TI *node, TI *loopNode, int mode );
const char *makeOrderName( const char *url );
int checksum( const char *text, int length );
char *urlToService( int *service, const char *url );
char *service( int service );
char *genFullQualName( const char *furl, const char *url );
int urlHasFilename( const char *url );
enum Documenttype doctype( const char *url, const char *text );
char *skipService( const char *url );

/* picture functions */
PL *createPicEntry( const char *url );
PL *picInMem( const char *url );
PL *addPicEntry( const char *url );

/* mirror functions */
char *genFilename( const char *url );
int genDirectories( const char *fname );
char *expandMirrorDir( const char *md );
char *rewriteUrl( const char *furl, const char *url );

/* Lists */
char *htmlErrorString( int c );
const char *substituteSpecialChars( const char *t );

/* Parser */
void parseHtml( int mode, FILE *outfile, TI *node, const char *text, int size );

#endif /* _HTML_PRIV_H */



