#include "../document.h"
#include "html_priv.h"
#include <string.h>
#include <pwd.h>
#include <unistd.h>
#include <sys/types.h>
#include <ctype.h>
#include <fcntl.h>

/*
  called once to expand the mirror dir.

  return NULL if mirrordir wrong
*/

char *expandMirrorDir( const char *md )
{
  char *m = (char *)md;
  struct passwd *pwd;
  
  if( strlen( md ) < 1 )
    return NULL;

  BUF[0] = '\0';

  /* expand homedir */
  if( *m == '~' )
  {
    if( ( pwd = getpwuid( getuid() ) ) )
    {
      strncpy( BUF, pwd->pw_dir, BUFFERSIZE - 1 );
      BUF[ BUFFERSIZE ] = '\0';
    }
    else
      return NULL;
    m++;
  }

  /* if no slash at beginning apend one */
  if( *m != '/' )
    strcat( BUF, "/" );

  strcat( BUF, m );

  if( BUF[ strlen( BUF ) - 1 ] != '/' )
    strcat( BUF, "/" );

  /* TODO check if mirrordir writeable */
  dbg( DI, DBG_HTML | 3, "expanded mirror dir %s to %s", md, BUF );

  return BUF;
}

/*
  generate full path name of url for mirror
  the url has to be fully qualified!

  ex.: mirrordir = /tmp
  url = http://www.linuxnow.com/
  -> /tmp/www.linuxnow.com/index.html
  give pointer to fname back

*/

char *genFilename( const char *url )
{
  char *u = (char *)url, *u1;
  int dbuf = FALSE;

  if( url == (const char*)&BUF )
  {
    dbuf = TRUE;
    u = strdup( url );
  }

  /* skip service tag "http://asdjasd/toto" becomes "asdjasd/toto" */
  if( ( u1 = strstr( u, ":/" ) ) )
    while( *(++u1) == '/' ) ;
  /* the else part is not necessary -> happens never... */
  else
  {
    if( *u == '/' )
      u1 = u + 1;
    else
      u1 = u;
  }

  strcpy( BUF, CH.mirrorpath );
  strcat( BUF, u1 );

  if( !urlHasFilename( url ) )
  {
    if( BUF[ strlen( BUF ) - 1 ] != '/' )
      strcat( BUF, "/" );
    strcat( BUF, DEFAULTNAME );
  }

  dbg( DI, DBG_HTML | 3, "created filename %s from url %s", BUF, url );

  if( dbuf ) free( u );
  return BUF;
}

int genDirectories( const char *fname )
{
  char *p, *p2;
  int l;

  if( fname == NULL )
    return FALSE;
  if( ( l = strlen( fname ) ) == 0 )
    return FALSE;

  p = strdup( fname );
  /* kill filename */
  p2 = strrchr( p, '/' );
  *p2 = '\0';

  /* path already exists */
  if( chdir( p ) == 0 )
  {
    free( p );
    return TRUE;
  }

  *p2 = '/';
  *(p2+1) = '\0';

  /* skip first slash */
  p2 = p + 1;
  while( p2 = strchr( p2 , '/' ) )
  {
    *p2 = '\0';
    if( chdir( p )  && ( mkdir( p, PERM_DIR) != 0 ) )
    {
      dbg( DI, DBG_HTML | 1, "could not create directory %s", p );
      free( p );
      return FALSE;
    }
    *p2++ = '/';
  }

  dbg( DI, DBG_HTML | 2, "created directory %s", p );

  free( p );
  return TRUE;
}

/*
  rewrite the url relative to the father url

*/
char *rewriteUrl( const char *furl, const char *url )
{
  char *fu, *fu2, *fu3, *u3, *u2, *u, *ru;
  int l1, l2, fmal = FALSE, umal = FALSE;

  if( furl == NULL || url == NULL )
    return NULL;

  dbg( DI, DBG_HTML | 3, "rewriting url %s with father %s", url, furl );

  /* if urls have no filename ensure that there is a slash at the end */
  if( !urlHasFilename( furl ) && furl[ (l1 = strlen( furl )) - 1 ] != '/' )
  {
    fu3 = malloc( l1 + 2 );
    strcpy( fu3, furl);
    strcat( fu3, "/" );
    fmal = TRUE;
  }
  else
    fu3 = (char *)furl;

  if( !urlHasFilename( url ) && url[ (l2 = strlen( url )) - 1 ] != '/' )
  {
    u3 = malloc( l2 + 2 );
    strcpy( u3, url);
    strcat( u3, "/" );
    umal = TRUE;
  }
  else
    u3 = (char *)url;

  /* TODO test furl, url auf BUF */

  fu = fu2 = skipService( fu3 );
  u = u2 = skipService( u3 );

  BUF[0] = '\0';

  while( *fu && *u && ( tolower( *fu ) == tolower( *u ) ) )
  {
    fu++;
    u++;
  }

  /* TODO: absolute links! */

  /* url is deeper as father */
  if( *fu == '\0' )
  {
    strcpy( BUF, "./");
    /* TODO test auf bufferlaenge */
    strcat( BUF, u );
  }
  else
  {
    /* go back to last slash */
    while( ( u >= u2 ) && *(u-1) != '/' ) u--;
    /* repeat "../" as often as there are slashes in the father url remaining */
    while( *fu != '\0' )
    {
      if( *fu == '/' )
	strcat( BUF, "../");
      fu++;
    }
    strcat( BUF, u );
  }

  if( fmal ) free( fu3 );
  if( umal ) free( u3 );

  ru = BUF;
  dbg( DI, DBG_HTML | 3, "rewrote url %s with father %s to %s", url, furl, ru );
  return ru;
}
