#ifndef _HTML_H
#define _HTML_H

/**********************************************************************/
/* begin of public interface                                          */
/**********************************************************************/

#define NAME_MAXLEN 200  /* name of title */
#define FILE_MAXLEN 400  /* name of files */
#define CHECKSUMLEN 200

#define DEFAULTNAME "index.html"

#define PERM_DIR  0755
#define PERM_FILE 0644

#define BUFFERSIZE 4096  /* 4 kb */

#define SP ' '
#define LF '\n'
#define CR '\r'
#define TB '\t'

#include "../layout/layout_struc.h"

/* document can be of these types ... */
enum Documenttype { Unknown, HTMLDoc, TextFile, PackedFile, Graphic, CGI, Java, Perl, Error };

struct NextTreeInfo                  /* list for next docs in the tree */
{
  struct TreeInfo *tree;             /* child of tree */
  struct NextTreeInfo *next;         /* to next child */
  struct layout_NextTreeInfo layout;
};

struct TreeInfo
{
  /* for HTML - internal use */

  int active;                        /* !check this befor you draw! */
                                     /* (cleared by stoploadingnode...) */ 
  struct Results *address;           /* unique address from http_order */
  int checksum;                      /* calculated checksum of doc */
  int length;                        /* length of document in bytes */
  int depth;                         /* this node has depth in tree */
  int loaded;                        /* set if document is already loaded */

  /* for LAYOUT and VIEW */
  char *url;                  /* URL of the document */
  /*char location[ URL_MAXLEN ]; */             /* location of file in mirror */
  enum Documenttype doctype;         /* which type is this document */
  char title[ NAME_MAXLEN ];               /* title of the document if HTML */
  int mailto;                        /* number of mailto: in HTML doc */
  int graphic;                       /* number of graphics in HTML doc */
  int links;                         /* number of extern links (href="a.gz") */
  int intlinks;                      /* number of intern links (href="#top") */

  struct layout_TreeInfo layout;     /* used by LAYOUT */

  /* dynamic structure connections */
  struct TreeInfo *father;           /* !!will be removed soon!! */
  struct NextTreeInfo *nextFather;   /* list of _all_ father nodes */
  struct NextTreeInfo *nextTree;     /* list of children nodes */
  struct TreeInfo *nextList;         /* next documents in linear list */
};

extern void html_initialize();
/* call this before to initialize HTML */

extern void html_free();
/* call this arterwards to free memory allocated by HTML */

extern int html_buildWebTree(); /* PHR type changed */
/* called by timed entry to check if documents are available */
/* builds tree in memory and requests further needed documents */
/* stores files in mirror and replaces links to already mirrored files */

extern struct TreeInfo *html_getRoot();
/* returns root of WebTree structure in memory */
/* start of linear list and tree */

extern int html_startLoading( char *url );
/* set WebTree root to url and start fetching documents */
/* returns 0 on success, otherwise -1 on error */

extern void html_stopLoading();
/* complete STOP */ 

extern void html_stopLoadingNode( struct TreeInfo *node );
/* stops loading a specified node and its subnodes (kills HTTP requests) */

extern void html_startLoadingNode( struct TreeInfo *node );
/* starts loading at a specified node (generate new HTTP requests) */

extern void html_getUrl( char* ,void( * )( int, int, char *, void * ), void * );
/* Order an url with this function, it checks if the url is 
   available in the mirror, or if it must be loaded from an http server.
   Whatever, your callback will be called like this
     callback(
               status of http (200 indicates success!),
             size of text in byte,
               pointer to text,
               pointer to your specific data );

  !!THE USER IS IN CHARGE OF FREEING THE MEMORY HOLDING THE TEXT!!

  status as described in http.h and ...

  -21   can not open file 
  -22   can not read file
  -23   aborted (PHR)
*/

extern void html_substituteMirrorLocations( void );
/* resolves addresses to WWW-files, which are stored in mirror, to local */
/* ones and local addresses to documentents which are not in mirror are */
/* resolved to full ones */

/**********************************************************************/
/* end of public interface                                            */
/**********************************************************************/

struct ExtReq
{
  struct Results *res;
  void           *users_data;
  void           ( *callback )( int, int, char * , void * );
  struct ExtReq  *next;
};

struct PicList
{
  struct Results *address;
  char   *url;
  /*  char   location[ FILE_MAXLEN ];*/
  /*  int    checksum;*/ /* WHY THIS??? (*shock*) */
  struct PicList *next;
};

struct Html
{
  struct TreeInfo *root;                  /* pointer to root of WebTree */
  struct PicList  *piclist;               /* root to picture (GIF, JPG, ...) list */
  int             currentMirrorSize;      /* current mirror size in bytes */
  char            mirrorpath[ FILE_MAXLEN ]; /* mirrorpath absolute */
  struct ExtReq   *extreq;                /* extern request list */
};

#endif /* _HTML_H */
