#ifndef _DOCUMENT_H
#define _DOCUMENT_H

#ifndef max
#define max(a, b)  ( (a) > (b) ? (a) : (b) )
#endif
#ifndef min
#define min(a, b)  ( (a) < (b) ? (a) : (b) )
#endif

#undef FALSE
#define FALSE 0
#undef TRUE
#define TRUE (!FALSE)


/* debug defines */

#define DBG_HTTP 4
#define DBG_HTML 8
#define DBG_LAYOUT 16
#define DBG_VIEW 32
#define DBG_MAIN 64

#define DBG_LEVEL 0

#define DI __LINE__,__FUNCTION__,__FILE__

/* module headers */

#include "http/http.h"
#include "html/html.h"
#include "layout/layout.h"
#include "view/view.h"
#include "pref/pref.h"

struct Document
{
  struct Http http;
  struct Html html;
  struct View view;
  struct Layout layout;
  struct Pref pref;
};

extern struct Document *context;

#endif




