#ifndef _DLG_PREF_H
#define _DLG_PREF_H

#include "dlg_inextab.h"
#include "dlg_viewtab.h"
#include "dlg_httptab.h"
#include "dlg_htmltab.h"

class DlgInexTab : public DlgInexTabData
{
    Q_OBJECT;

private:
    struct Pref* mypref;
    QListBox* actL;

private slots:
    void textchg(const char*);
    void aclick();
    void dclick();
    void eclick();
    void help();
    void ls(int);

    protected slots:
      void includeClicked();
    void excludeClicked();

public slots:
    void readForm();
    void setForm();

public:

    DlgInexTab(struct Pref* p, QWidget* parent = NULL, const char* name = NULL);
    virtual ~DlgInexTab();
};

class DlgViewTab : public DlgViewTabData
{
    Q_OBJECT;

private:
    struct Pref* mypref;

private slots:
    void help();

public slots:
    void readForm();
    void setForm();


public:

    DlgViewTab(struct Pref* p, QWidget* parent = NULL, const char* name = NULL);
    virtual ~DlgViewTab();
};

class DlgHttpTab : public DlgHttpTabData
{
    Q_OBJECT;

private:
    struct Pref* mypref;

private slots:
    void help();

public slots:
    void readForm();
    void setForm();

public:

    DlgHttpTab(struct Pref* p, QWidget* parent = NULL, const char* name = NULL);

    virtual ~DlgHttpTab();
};

class DlgHtmlTab : public DlgHtmlTabData
{
    Q_OBJECT;

private:
    struct Pref* mypref;

private slots:
    void help();

public slots:
    void readForm();
    void setForm();

public:

    DlgHtmlTab(struct Pref* p, QWidget* parent = NULL, const char* name = NULL );
    virtual ~DlgHtmlTab();

};
#endif
