#include "../pref/pref.h"
#include "dlg_pref.h"
#include <stdlib.h>
#include <stdio.h>
#include <kapp.h>


DlgInexTab::DlgInexTab(struct Pref* p,QWidget* parent,const char* name)
  :DlgInexTabData( parent, name )
{
  mypref = p;
  addB->setEnabled(FALSE);
  delB->setEnabled(FALSE);
  editB->setEnabled(FALSE);
  actL = includeL;

  QObject::connect(lineT,SIGNAL(textChanged(const char*)),this,
		   SLOT(textchg(const char*)));
  QObject::connect(lineT,SIGNAL(returnPressed()),this,SLOT(aclick()));
  QObject::connect(addB,SIGNAL(clicked()),this,SLOT(aclick()));
  QObject::connect(includeL,SIGNAL(highlighted(int)),this,SLOT(ls(int)));
  QObject::connect(excludeL,SIGNAL(highlighted(int)),this,SLOT(ls(int)));
  QObject::connect(delB,SIGNAL(clicked()),this,SLOT(dclick()));
  QObject::connect(editB,SIGNAL(clicked()),this,SLOT(eclick()));
  QObject::connect(helpB,SIGNAL(clicked()),this,SLOT(help()));
}


void DlgInexTab::help()
{
  kapp->invokeHTMLHelp("kwebtree/pref.html", "Scope" );
}

DlgInexTab::~DlgInexTab()
{
}

void DlgInexTab::excludeClicked()
{
  selectInclude->setChecked( FALSE );

  includeL->setEnabled(FALSE); 
  excludeL->setEnabled(TRUE);  
  actL=excludeL;

  if(actL->currentItem()<0)
  {
    delB->setEnabled(FALSE);
    editB->setEnabled(FALSE);
  }
  else
  {
    delB->setEnabled(TRUE);
    editB->setEnabled(TRUE);
  }
}

void DlgInexTab::includeClicked()
{
  selectExclude->setChecked( FALSE );

  includeL->setEnabled(TRUE);  
  excludeL->setEnabled(FALSE); 
  actL=includeL;

  if(actL->currentItem()<0)
  {
    delB->setEnabled(FALSE);
    editB->setEnabled(FALSE);
  }
  else
  {
    delB->setEnabled(TRUE);
    editB->setEnabled(TRUE);
  }
}

void DlgInexTab::eclick()
{
  actL->changeItem(lineT->text(),actL->currentItem());
  editB->setEnabled(FALSE);
}

void DlgInexTab::dclick()
{
  actL->removeItem(actL->currentItem());
  if(actL->currentItem()>=0) lineT->setText(actL->text(actL->currentItem())); 
    else
    {
      delB->setEnabled(FALSE);
      editB->setEnabled(FALSE);
      lineT->setText(""); 
    }
  addB->setEnabled(FALSE);
}


void DlgInexTab::ls(int i)
{
  lineT->setText(actL->text(i));

  delB->setEnabled(TRUE);
  addB->setEnabled(FALSE);
}


void DlgInexTab::aclick()
{
  actL->insertItem(lineT->text());
  lineT->setText("");
}

void DlgInexTab::textchg(const char* nt)
{
  editB->setEnabled(FALSE);
  if(strlen(nt))
    {
      addB->setEnabled(TRUE);
      if(actL->currentItem()>=0)
	  if(strcmp(nt,actL->text(actL->currentItem())))
	     editB->setEnabled(TRUE);
    }
  else
    addB->setEnabled(FALSE);
}

void DlgInexTab::readForm()
{
  struct Searchlist* c;
  struct Searchlist* d;
  struct Searchlist** p;
  unsigned int i,n;

  mypref->searchdepth = strtol(depthT->text(),NULL,10);
  
  c=mypref->searchincludelist;
  p=&(mypref->searchincludelist);
  n=includeL->count();
  for(i=0;i<n;i++)
    {
      if(c==NULL) 
	{
	c=(struct Searchlist*)malloc(sizeof(struct Searchlist));
	c->next=NULL;
	*p=c;
	}
      strcpy(c->domain,includeL->text(i));
      p=&(c->next);
      c=c->next;
    }

  *p = NULL;

  while(c)
    {
      d=c;
      c=c->next;
      free(d);
    }

  c=mypref->searchexcludelist;
  p=&(mypref->searchexcludelist);
  n=excludeL->count();
  for(i=0;i<n;i++)
    {
      if(c==NULL) 
	{
	c=(struct Searchlist*)malloc(sizeof(struct Searchlist));
	c->next=NULL;
	*p=c;
	}
      strcpy(c->domain,excludeL->text(i));
      p=&(c->next);
      c=c->next;
    }

  *p = NULL;

  while(c) /* If there are less entries than before, we have to free some*/
    {
      d=c;
      c=c->next;
      free(d);
    }

  if( selectInclude->isChecked() && includeL->count() )
  {
    mypref->searchinclude = 1;
    includeClicked();
  }
  else
  {
    mypref->searchinclude = 0;
    excludeClicked();
  }
}

void DlgInexTab::setForm()
{
  char b[20];
  struct Searchlist* i;

  sprintf(b,"%d",mypref->searchdepth);
  depthT->setText(b);
  
  i=mypref->searchincludelist;
  while(i)
    {
      includeL->insertItem((const char*)&(i->domain));
      i=i->next;
    }

  i=mypref->searchexcludelist;
  while(i)
    {
      excludeL->insertItem((const char*)&(i->domain));
      i=i->next;
    }

  selectInclude->setChecked( mypref->searchinclude );
  selectExclude->setChecked( mypref->searchinclude == 0 );

  if(mypref->searchinclude)
    includeClicked();
  else
    excludeClicked();		/* this will set actL */
}

DlgViewTab::DlgViewTab(struct Pref* p,QWidget* parent,const char* name)
  : DlgViewTabData( parent, name )
{
  mypref = p;
  QObject::connect(helpB,SIGNAL(clicked()),this,SLOT(help()));

}


void DlgViewTab::help()
{
  kapp->invokeHTMLHelp("kwebtree/pref.html", "View" );
}

DlgViewTab::~DlgViewTab()
{
}

void DlgViewTab::readForm()
{
  if(tbCheck->isChecked()) mypref->viewtype = topdownview;
  if(lrCheck->isChecked()) mypref->viewtype = leftrightview;
  if(bCheck->isChecked()) mypref->viewtype = browserview;
  /*  if(coCheck->isChecked()) mypref->viewtype = centralview;*/
  
  if(titleCheck->isChecked()) mypref->nodecontent = title;
  if(urlCheck->isChecked()) mypref->nodecontent = url;
  if(showOrderedC->isChecked()) mypref->viewshowordered = TRUE;
  else mypref->viewshowordered = FALSE;
}

void DlgViewTab::setForm()
{
  switch(mypref->viewtype)
    {
    case topdownview:    tbCheck->setChecked(TRUE); break;
    case leftrightview:  lrCheck->setChecked(TRUE); break;
    case browserview:    bCheck->setChecked(TRUE);  break;
      /*    case centralview:    coCheck->setChecked(TRUE); break;*/
    }
  
  switch(mypref->nodecontent)
    {
    case title:     titleCheck->setChecked(TRUE); break;
    case url:       urlCheck->setChecked(TRUE);   break;
    }

  showOrderedC->setChecked(mypref->viewshowordered);
  
}

DlgHtmlTab::DlgHtmlTab(struct Pref* p,QWidget* parent,const char* name)
  :DlgHtmlTabData(parent, name)
{
  mypref = p;
  QObject::connect(helpB,SIGNAL(clicked()),this,SLOT(help()));

}

void DlgHtmlTab::help()
{
  kapp->invokeHTMLHelp("kwebtree/pref.html", "Mirror" );
}

DlgHtmlTab::~DlgHtmlTab()
{
}


void DlgHtmlTab::readForm()
{
  mypref->mirrorhttp = httpCheck->isChecked();
  mypref->mirrorpic  = pictureCheck->isChecked();
  mypref->mirrorother = binCheck->isChecked();
  mypref->mirrorsizemax = strtol(sizeText->text(),NULL,10)*1048576;
  strcpy(mypref->mirrorpath,pathText->text());
}

void DlgHtmlTab::setForm()
{
  char b[20];
  
  httpCheck->setChecked(mypref->mirrorhttp);
  pictureCheck->setChecked(mypref->mirrorpic);
  binCheck->setChecked(mypref->mirrorother);
  sprintf(b,"%d",mypref->mirrorsizemax/1048576);
  sizeText->setText(b);
  pathText->setText(mypref->mirrorpath);
}


DlgHttpTab::DlgHttpTab(struct Pref* p,QWidget* parent,const char* name)
  :DlgHttpTabData( parent, name )
{
  mypref=p;
  QObject::connect(helpB,SIGNAL(clicked()),this,SLOT(help()));

}

void DlgHttpTab::help()
{
  kapp->invokeHTMLHelp("kwebtree/pref.html", "Http" );
}

DlgHttpTab::~DlgHttpTab()
{
}

void DlgHttpTab::readForm()
{
  mypref->http_threadsmax = strtol(connectionsText->text(),NULL,10);
  //  mypref->http_timeout = strtol(timeoutText->text(),NULL,10);
  strcpy(mypref->http_proxy,proxyText->text());
}

void DlgHttpTab::setForm()
{
  char b[20];

  sprintf(b,"%d",mypref->http_threadsmax);
  connectionsText->setText(b);
  //  sprintf(b,"%d",mypref->http_timeout);
  //  timeoutText->setText(b);
  proxyText->setText(mypref->http_proxy);
}









