#ifndef _DLGAPPEAR_H
#define _DLGAPPEAR_H

#include <qslider.h>

#include "../webtree.h"

#include "dlg_fonttab.h"
#include "dlg_coltab.h"
#include "dlg_other.h"

class DlgAppearFont : public DlgFontTabData
{
  Q_OBJECT;

public:
  DlgAppearFont(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0);
  virtual ~DlgAppearFont();

  public slots:
    void readForm();
  void setForm();

  protected slots:
    void setTitleFont();
  void checkFontSize( const char * );
  void help();

private:
  QFont font;
  Appearance *a;
  WebTree *wt;
  
  void updateFont();
};

class DlgAppearColor : public DlgColorTabData
{
  Q_OBJECT;

public:
  DlgAppearColor(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0);
  virtual ~DlgAppearColor();

  public slots:
    void readForm();
  void setForm();
  void help();
  void colBackSel( const QColor& );
  void colTextSel( const QColor& );
  void colLineSel( const QColor& );
  void colHtmlSel( const QColor& );
  void colGraphicSel( const QColor& );
  void colPackedSel( const QColor& );
  void colOtherSel( const QColor& );
  void colOrderedSel( const QColor& );
  void colErrorSel( const QColor& );
  void colCollapsedSel( const QColor& );

private:
  Appearance *a;
  QColor back, text, line, html, graphic, packed, other, error, ordered, collapsed;
  WebTree *wt;
};

class DlgAppearOther : public DlgOtherData
{
  Q_OBJECT;

public:
  DlgAppearOther(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0);
  virtual ~DlgAppearOther();

  public slots:
    virtual void changeLensExponent(int);
  void readForm();
  void setForm();

 private:
  Appearance *a;
  WebTree *wt;
};

#endif
