#include <kfontdialog.h>
#include "dlg_appear.h"

DlgAppearFont::DlgAppearFont(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0)
  : DlgFontTabData( parent, name )
{
  a = appear;
  wt = w;
}

DlgAppearFont::~DlgAppearFont()
{
}


void DlgAppearFont::readForm()
{
  int v;
  a->font = font;
  wt->updateAllViews();

  v = atoi( fontMinSize->text() );
  a->fontminsize = v ? v : 8;

  v = atoi( fontSizeMax->text() );
  a->fontmaxsize = v ? v : 14;
}

void DlgAppearFont::setForm()
{
  char buf[40];

  font = a->font;
  updateFont();

  sprintf(buf, "%d", a->fontminsize );
  fontMinSize->setText( buf );

  sprintf(buf, "%d", a->fontmaxsize );
  fontSizeMax->setText( buf );
}

void DlgAppearFont::setTitleFont()
{
  KFontDialog::getFont( font );
  updateFont();
}

void DlgAppearFont::updateFont()
{
  QString str;
  titleFontSample->setFont(font);

  str.sprintf("Family: %s", font.family());
  titleFontFamily->setText(str.data());

  str.sprintf("Weight: %d ", font.weight());
  if(font.bold())
    str += "(bold) ";
  titleFontWeight->setText(str.data());

  // TODO other styles
}

void DlgAppearFont::checkFontSize( const char * )
{
  // TODO check if valid font size
}

void DlgAppearFont::help()
{
  kapp->invokeHTMLHelp("kwebtree/appear.html", "Font" );
}

DlgAppearColor::DlgAppearColor(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0)
  : DlgColorTabData(parent, name)
{
  a = appear;
  wt = w;

  connect( colBackgrnd, SIGNAL( activated(const QColor&) ),
	  this, SLOT( colBackSel(const QColor&) ) );

  connect( colText, SIGNAL( activated(const QColor&) ),
	  this, SLOT( colTextSel(const QColor&) ) );

  connect( colLine, SIGNAL( activated(const QColor&) ),
	  this, SLOT( colLineSel(const QColor&) ) );

  connect( colHTMLDoc, SIGNAL( activated(const QColor&) ),
	  this, SLOT( colHtmlSel(const QColor&) ) );

  connect( colPicDoc, SIGNAL( activated(const QColor&)), 
	  this, SLOT(colGraphicSel(const QColor&)));

  connect( colPacked, SIGNAL( activated(const QColor&)), 
	  this, SLOT(colPackedSel(const QColor&)));

  connect( colOther, SIGNAL( activated(const QColor&) ), 
	  this, SLOT( colOtherSel(const QColor&) ) );

  connect( colError, SIGNAL( activated(const QColor&) ), 
	  this, SLOT( colErrorSel(const QColor&) ) );

  connect( colOrdered, SIGNAL( activated(const QColor&) ), 
	  this, SLOT( colOrderedSel(const QColor&) ) );

  connect( colCollapsed, SIGNAL( activated(const QColor&) ), 
	  this, SLOT( colCollapsedSel(const QColor&) ) );
}

void DlgAppearColor::help()
{
  kapp->invokeHTMLHelp("kwebtree/appear.html", "Colors" );
}

DlgAppearColor::~DlgAppearColor()
{
}

void DlgAppearColor::readForm()
{
  a->back = back;
  a->line = line;
  a->text = text;
  a->html = html;
  a->graphic = graphic;
  a->packed = packed;
  a->other = other;
  a->ordered = ordered;
  a->error = error;
  a->collapsed = collapsed;

  wt->updateAllViews();
}

void DlgAppearColor::setForm()
{
  back = a->back;
  text = a->text;
  line = a->line;
  html = a->html;
  graphic = a->graphic;
  packed = a->packed;
  other = a->other;
  error = a->error;
  ordered = a->ordered;
  collapsed = a->collapsed;

  colBackgrnd->setColor( back );
  colText->setColor( text );
  colLine->setColor( line );
  colHTMLDoc->setColor( html );
  colPicDoc->setColor( graphic );
  colPacked->setColor( packed );
  colOther->setColor( other );
  colOrdered->setColor( ordered );
  colError->setColor( error );
  colCollapsed->setColor( collapsed );
}

void DlgAppearColor::colBackSel( const QColor &c )
{
  back = c;
  colBackgrnd->update();
}

void DlgAppearColor::colTextSel( const QColor &c )
{
  text = c;
  colText->update();
} 

void DlgAppearColor::colLineSel( const QColor &c )
{
  line = c;
  colLine->update();
} 

void DlgAppearColor::colHtmlSel( const QColor &c )
{
  html = c;
  colHTMLDoc->update();
}

void DlgAppearColor::colGraphicSel( const QColor &c )
{
  graphic = c;
  colPicDoc->update();
} 

void DlgAppearColor::colPackedSel( const QColor &c )
{
  packed = c;
  colPacked->update();
}

void DlgAppearColor::colOtherSel( const QColor &c )
{
  other = c;
  colOther->update();
}

void DlgAppearColor::colOrderedSel( const QColor &c )
{
  ordered = c;
  colOrdered->update();
}

void DlgAppearColor::colErrorSel( const QColor &c )
{
  error = c;
  colError->update();
}

void DlgAppearColor::colCollapsedSel( const QColor &c )
{
  collapsed = c;
  colCollapsed->update();
}

DlgAppearOther::DlgAppearOther(WebTree *w, Appearance *appear, QWidget *parent = 0, const char *name = 0)
  : DlgOtherData( parent, name )
{
  a = appear;
  wt = w;
}

DlgAppearOther::~DlgAppearOther()
{
}

void DlgAppearOther::readForm()
{
  a->mouseLinks = show_mlinks->isChecked();
  a->lens_effect = lens_effect->isChecked();
  a->lens_exp = ( (double)lens_slider->value() ) / 10;
  a->drag_method1 = cdrag_method1->isChecked();
}

void DlgAppearOther::setForm()
{
  show_mlinks->setChecked( a->mouseLinks );
  lens_effect->setChecked( a->lens_effect );
  cdrag_method1->setChecked( a->drag_method1 );
  cdrag_method2->setChecked( !a->drag_method1 );
  lens_slider->setValue( (int)( a->lens_exp * 10 ) );
}

void DlgAppearOther::changeLensExponent( int val )
{
  QString s;
  s.setNum( ( (double) val ) / 10 );
  exponent_label->setText( s );
}
