# Generated automatically from Makefile.in by configure.
#
# Main Makefile for K WebTree
#
# This file is part of K WebTree
#
# K WebTree is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2, or (at your option)
# any later version.
#
# K WebTree is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with K WebTree; see the file COPYING.  If not, write to
# the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
#


SHELL = /bin/sh

AR		= ar
CC    		= gcc
MOC   		= /usr/bin/moc

INC_DIRS  	= -I$(KDEDIR)/include -I$(QTDIR)/include -I/usr/X11R6/include -I..

CFLAGS		= -g -Wall -DSTDC_HEADERS

LFLAGS		= -g

SUBDIRS 	= http html layout dlg view

SOURCES		= webtree.cpp jpeg.cpp
SRCMETA		= mwebtree.cpp
OBJECTS		= webtree.o jpeg.o http/http.o html/html.o layout/layout.o view/view.o dlg/dlg.o
OBJMETA		= mwebtree.o

GUILIBS		= -lkdecore -lkdeui -ljpeg -lqt -lXext -lX11 
SYSLIBS		= -lm -lfl

LIBRARIES	= -L$(KDEDIR)/lib -L/usr/X11R6/lib $(SYSLIBS) $(GUILIBS)

TARGET		= kwebtree

export


############# Install ##############

INSTALL = /usr/bin/install -c -m 0755
INSTALL_DATA = /usr/bin/install -c -m 0644
INSTALL_DIR = /usr/bin/install -c -d -m 0755

BINDIR = /usr/local/kde/bin
HTMLDIR = $(KDEDIR)/share/doc/HTML/en
KDELNKDIR = $(KDEDIR)/share/applnk
ICONDIR = $(KDEDIR)/share/icons
MYDIR = $(KDEDIR)/share/apps/kwebtree
MYTOOLBDIR = $(MYDIR)/toolbar
LOCALEDIR = $(KDEDIR)/share/locale
MIMEDIR = $(KDEDIR)/share/mimelnk


#######	Implicit rules

.SUFFIXES: .cpp .deps

.cpp.o: 
	$(CC) -c $(CFLAGS) $(INC_DIRS) $<

#
######	Build rules #############
#

all:    webtree_subdirs $(TARGET) 

$(TARGET): $(OBJECTS) $(OBJMETA)
	$(CC) $(LFLAGS) $(LIB_DIRS) -o $(TARGET)  $^ $(LIBRARIES)


webtree_subdirs: dummy
	@ set -e; for i in $(SUBDIRS); do $(MAKE) -C $$i; done


.deps: $(SRCMETA) $(SOURCES)
	@ makedepend $(INC_DIRS) $(SOURCES) $(SRCMETA) -f- >.deps 2>/dev/null 

clean:
	-rm -f core .deps
	-rm -f *.o *.bak *BAK *~ *% #*
	-rm -f $(SRCMETA) $(TARGET)
	@ for i in $(SUBDIRS); do $(MAKE) -C $$i clean; done

messages.po: dlg/tdlg_*.cpp webtree.cpp
	xgettext -C -ktranslate webtree.cpp dlg/tdlg_*.cpp view/wtview.cpp

$(SRCMETA): m%.cpp : %.h
	$(MOC) $< -o $@


############# Install ##############

install: all
	$(INSTALL_DIR) $(BINDIR)
	$(INSTALL) $(TARGET) $(BINDIR)
	$(INSTALL_DIR) $(HTMLDIR)/kwebtree
	$(INSTALL_DATA) doc/*.* $(HTMLDIR)/kwebtree
	$(INSTALL_DIR)  $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/load0.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/load1.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/load2.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/load3.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/lr_view.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/mlink.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/noload.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/td_view.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/tl_view.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/cv_view.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/ti_comp.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/ti_doc.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/ti_other.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/ti_pic.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/pause.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) pixmap/cont.xpm $(MYTOOLBDIR)
	$(INSTALL_DATA) dlg/webtree-logo.jpg $(MYDIR)
	$(INSTALL_DATA) pixmap/wtdnd.xpm $(MYDIR)
	$(INSTALL_DATA) WebTree.kdelnk $(KDELNKDIR)/Utilities
	$(INSTALL_DATA) x-webtree.kdelnk $(MIMEDIR)/application
	$(INSTALL_DATA) pixmap/kwebtree.xpm $(ICONDIR)
	$(INSTALL_DATA) pixmap/wtfile.xpm $(ICONDIR)

uninstall:
	rm -f $(BINDIR)/$(TARGET)
	rm -rf $(HTMLDIR)/kwebtree
	rm -f $(MYTOOLBDIR)/load0.xpm
	rm -f $(MYTOOLBDIR)/load1.xpm 
	rm -f $(MYTOOLBDIR)/load2.xpm 
	rm -f $(MYTOOLBDIR)/load3.xpm 
	rm -f $(MYTOOLBDIR)/lr_view.xpm
	rm -f $(MYTOOLBDIR)/mlink.xpm 
	rm -f $(MYTOOLBDIR)/noload.xpm
	rm -f $(MYTOOLBDIR)/td_view.xpm
	rm -f $(MYTOOLBDIR)/tl_view.xpm
	rm -f $(MYTOOLBDIR)/cv_view.xpm
	rm -f $(MYTOOLBDIR)/ti_comp.xpm
	rm -f $(MYTOOLBDIR)/ti_doc.xpm
	rm -f $(MYTOOLBDIR)/ti_other.xpm
	rm -f $(MYTOOLBDIR)/ti_pic.xpm
	rm -f $(MYTOOLBDIR)/pause.xpm
	rm -f $(MYTOOLBDIR)/cont.xpm
	rm -f $(MYDIR)/webtree-logo.jpg
	rm -f $(MYDIR)/wtdnd.xpm
	rm -f $(KDELNKDIR)/Utilities/WebTree.kdelnk
	rm -f $(MIMEDIR)/application/x-webtree.kdelnk
	rm -f $(ICONDIR)/kwebtree.xpm
	rm -f $(ICONDIR)/wtfile.xpm

dummy:

include .deps
