// basic.cc -- a few basic tools used by the main program
//
// mhtml -- an html mirroring program
//
// mhtml -- a program to mirror html pages recursively
// Copyright (C) 1996  Kevin M. Bealer
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
// USA.
// 
// You can send mail to the author at <kmb203@psu.edu> or:
// 
// Kevin M Bealer
// 94 Bowers Road
// Mertztown, PA 19539
//

#include<errno.h>
#include<stdio.h>
#include<unistd.h>
#include<String.h>
#include<fstream.h>
#include<sys/stat.h>
#include<sys/wait.h>
#include<sys/types.h>
#include<FlexLexer.h>

#include "mhtml.h"
#include "basic.h"
#include "UrlConvert.h"

// Global Variables ! Aaack! We have to pass these or redefine bits of the
// parser to allow passing info to the parse-thing.

extern String GlobalCurrPage; // html page being parsed.

// Translate the html into local references
int Translate(String original, String localized, 
              String remotepage, int verbose)
{
	if(verbose & V_DEBUG)
	{
		cout << "Translate(" << original << ", "
		     << localized << ", " << remotepage << ");" << endl;
	}
	ifstream orig((const char *)original);
	ofstream local((const char *)localized);

	if(! orig.good()) {
		cerr << "Error. Downloaded file <" << original 
		<< "> DNE.\n" << endl;
		return(1);
	}

	if(! local.good()) {
		cerr << "Error. Localized file <" << localized
		<< "> won't open for writing.\n" << endl;
		return(1);
	}

	// First we must be sure the baggage is securely
	// taped to the landing gear ...
	
	GlobalCurrPage = remotepage;

	FlexLexer* lexer = new yyFlexLexer(& orig, & local);

	if (!lexer) {
		cerr << "Lexer didn't allocate.  "
		"Are you short on core?" << endl;
		return(1);
	}

	while(lexer->yylex() != 0)
		;

	return(0);
}

// Runs shell script to get a file
int FetchPage(String in, String out, int verbose)
{
	Machete(out, verbose);

	char * v[4];
	v[0] = "fetchfile";			// fetchfile
	v[1] = new char [in.length() + 1];	// *1 (in)
	v[2] = new char [out.length() + 1];	// *2 (out)
	v[3] = NULL;

	strcpy(v[1], (const char *)in);
	strcpy(v[2], (const char *)out);

	pid_t pid = fork();
	if (pid == (pid_t) 0) { // Child process, right? right??
		execvp("fetchfile",v);
		cerr << "Returned! execvp() failed!" << endl;
	} else if (pid < (pid_t)0) {
		cerr << "fork() failed to fly :<" << endl;
	} else {
		if(verbose & V_OTHER) {
			cout << " working ... " << endl;
		}
		waitpid(pid, NULL, 0);
	}

	delete v[1];
	delete v[2];
	
	return(0);
}

int Machete(String path, int verbose)
{
	// Machete a non-existant path, given a path/filename
	// Test for existance of each directory up the tree and
	// make any that DNE
	String exists;
	struct stat tbuf;
	int valid;
	String chunk;

	if(verbose & V_OTHER) {
		cout << "Machete " << path << endl;
	}
	
	while(path.contains("/")) {
		exists += (path.before("/") + "/");
		path = path.after("/");
		chunk = exists + path.before("/");
		valid = stat((const char *) chunk, &tbuf);
		if ((valid == -1) && (errno == ENOENT)) {
			mkdir((const char *) chunk, (mode_t) 
			  (S_IRWXU | S_IRWXG | S_IRWXO));
		}
		else if (! S_ISDIR(tbuf.st_mode)) {
			cerr << "Non directory in path!" << endl
			<< exists << "<>" << path << endl;
			return(1);
		}
	}
	
	return(0);
}

void RecurseMirror(String pagename, String cachedir, String currentpage, 
		   int hopcount, int localhopcount, int verbose)
{
	// This function forks and runs mhtml on the next page
	// Unless it gets a low hopcount ...

	// Hopcount rules:
	// if accessing a local page, use same hop and localhop as given
	// if accessing a nonlocal page, use hop for both.

	if (! RelativelyLocal(pagename, currentpage))
		localhopcount = hopcount;

	hopcount = MAXIMUM(hopcount, 0);
	localhopcount = MAXIMUM(localhopcount, 0);
	
	if(verbose & V_OTHER) {
		cout << "(Local)Hopcount = " << localhopcount << endl;
	}
	
	if (localhopcount < 1)
		return;

	char * v[9];
	v[0] = "mhtml";			// mhtml
	v[1] = new char[pagename.length()+1];	// *1
	strcpy(v[1], (const char *) pagename);	// http://...
	v[2] = "-c";				// -c
	v[3] = new char[cachedir.length()+1];	// *3
	strcpy(v[3], (const char *) cachedir);	// (cachedir)
	v[4] = "-l";				// -l
	v[5] = new char[15];			// *5
	snprintf(v[5], 14, "%d", hopcount);	// (hopcount)
	v[6] = "-s";				// -s
	v[7] = new char[15];			// *7
	snprintf(v[7], 14, "%d", localhopcount); // (lochopcount)
	v[8] = NULL;
	
	if(verbose & V_OTHER) {
		cout << "Running a mirror of: " << pagename << endl;
		cout << "Cache dir = " << cachedir << endl;
		cout << endl;
	}
	
	pid_t pid = fork();
	if (pid == 0) { // child process
		execvp(v[0], v);
		cerr << "Execvp failed to execute!" << endl;
	} else if (pid < (pid_t) 0) { // error
		cerr << "Error! failed to fork! :(" << endl;
	} else { // parent
		waitpid(pid, NULL, 0);
		if(verbose & V_OTHER) {
			cout << "\nChild returned, continuing.\n" << endl;
		}
	}
	
	delete v[1];
	delete v[3];
	delete v[5];
	delete v[7];
}


