// WebRef.h
//
//
// mhtml -- a program to mirror html pages recursively
// Copyright (C) 1996  Kevin M. Bealer
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
// USA.
// 
// You can send mail to the author at <kmb203@psu.edu> or:
// 
// Kevin M Bealer
// 94 Bowers Road
// Mertztown, PA 19539
//
//
// Web reference class.
// 
// This stores a reference to one file on the web.

#include<String.h>

#ifndef WEBREF_H
#define WEBREF_H

#define WR_UNKNOWN	0
#define WR_INLINE	1
#define WR_BACKGR	2
#define WR_HREF		3

class WebRef {
public:
	WebRef(); // default constructor for list() etc.
	WebRef(int rt, String where, String what); // normal constructor.
	int RefType();
	String RemRef();
	int GetRetrieve(void);
	void SetRetrieve(int);
	friend operator==(WebRef, WebRef);
	friend operator<(WebRef, WebRef);
private:
	int reftype;   	// ie unknown or inline
	int retrieve;  	// ie 0 for no, 1 or hopcount for yes
	String refstring; // Stores a fully specified remote-type URL
};

operator==(WebRef, WebRef);
operator<(WebRef, WebRef);

#endif // WEBREF_H
