// WebRef.cc
//
//
// mhtml -- a program to mirror html pages recursively
// Copyright (C) 1996  Kevin M. Bealer
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
// USA.
// 
// You can send mail to the author at <kmb203@psu.edu> or:
// 
// Kevin M Bealer
// 94 Bowers Road
// Mertztown, PA 19539
//
// Web reference class.
// 
// This stores a reference to one file on the web.
//
// Should references such as <img src="refbutton.gif">
// be converted to full http://host... form?
//
// Mr. Random sez : yes.
//
// Advantages:
//   All references are same form, simplifies fetching, 
//   comparing hostnames, etc.
// Disadvantages:
//   loss of "information" (which is non significant)
//   increase in size of output (big whoop)

#include<String.h>

#include "WebRef.h"
#include "UrlConvert.h"

//#define DEBUG

WebRef::WebRef()
{
	reftype = WR_UNKNOWN;
	retrieve = 0;
	refstring = "";
}

WebRef::WebRef(int rt, String where, String what)
{
	reftype = rt; // ref type
	//
	// where is the current page's remote address.
	// where will be assumed correct!
	//
	// what is the reference encountered ie whatever was 
	// in the <img src=""> or <a href=""> quotes.
	//
	// (do not worry about how we got this information.)
	//

	String fn = where;
	while(fn.contains("/"))
		fn = fn.after("/");

	if(fn != "") // if current page has a filename
		where = where.before(fn); // cut it off

#ifdef DEBUG
	cerr << " worlds without filenames: " << where << endl;
	cerr << " material worlds         : " << what << endl;
#endif	

	if(what[0] == '/') { // Absolute path, but no hostname
		refstring = where.after("http://");
		refstring = refstring.before("/"); // just hostname now.
#ifdef DEBUG
		cout << "Are you a host-p (" << refstring << ")\n";
#endif
		refstring = "http://" + refstring + what;
		refstring = RemoteToRemote(refstring);
	} else { // Relative path/filename -or- full http:// reference

		String protocol = "";
		if(what.contains(":/"))
			protocol = what.before(":/");
#ifdef DEBUG
		cerr << "Protocol is :" << protocol << endl;
#endif /* DEBUG */
		if(protocol != "") { // full specification
			if(protocol == "http") {// just clean up the ref
				refstring = RemoteToRemote(what);
			} else { // full, non http url, leave as-is
				refstring = what;
			}
		} else { // Relative path/file
			refstring = where + what;
		}
	}
}

int WebRef::RefType()
{
	return reftype;
}

String WebRef::RemRef()
{
	return refstring;
}

void WebRef::SetRetrieve(int x)
{
	retrieve = x;
}

int WebRef::GetRetrieve(void)
{
	return retrieve;
}

int operator==(WebRef a, WebRef b)
{
// Should this be strict or stringonly ...
//
// Stringonly:
//   causes only one fetch of the item if it is listed under two types.
// Strict:
//   causes item to be evaluated for all references.
//
// If we do Unstrict, we will get an item that is listed in several
// references and only one of the references will survive, at random.
// Ergo strict comparisons for now.

	return ((a.refstring == b.refstring) && (a.reftype == b.reftype));
}

int operator<(WebRef a, WebRef b)
{
// ("hello",1) ("bye",2) which is first??
// For now we will do string-based, ie alphabetical, then by #

	return ((a.refstring < b.refstring) || 
			((a.refstring == b.refstring) 
			  && (a.reftype < b.reftype))
	);

}


