//
// urlconvert.cc (URL conversion functions)
//
//
// mhtml -- a program to mirror html pages recursively
// Copyright (C) 1996  Kevin M. Bealer
// 
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version
// 2 of the License, or (at your option) any later version.
// 
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
// 
// You should have received a copy of the GNU General Public
// License along with this program; if not, write to the Free
// Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139,
// USA.
// 
// You can send mail to the author at <kmb203@psu.edu> or:
// 
// Kevin M Bealer
// 94 Bowers Road
// Mertztown, PA 19539
//
//
// remote - http://hostname/path/to/file/filename.extension
// clocal - /cache/dir/hostname/path/to/file/filename.extension.orig
// vlocal - /cache/dir/hostname/path/to/file/filename.extension
//
// remote is the filename used to fetch from the remote host
// clocal is the cached version, should be ident contents. to remote
// vlocal is the clocal version, with paths rewritten for cache.

#include<assert.h>

#include "UrlConvert.h"
#include "mhtml.h"

extern int verbose;

//#define DEBUG

// Currently this only does full URLs (ie including hostname)
String RemoteToRemote(String URL)
{
	// Rather than try to correct errors in spec, we will
	// build a possibly correct URL from the given URL.

	String goodURL = "http://";

	if(URL.index("http://") == 0)
		URL = URL.after("http://");
	
	// First deal with simple hostname (http://www.sgi.com)
	if(!URL.contains("/"))
		URL+= "/";
	
	goodURL += (URL.before("/") + "/");
	URL = URL.after("/");
	
	// Now URL should only contain path and filename.

	// Process path elements
	while(URL.contains("/")) {
		goodURL += URL.before("/")+"/";
		URL = URL.after("/");
	}
	
	// Now we add the filename if there is one.
	// If there is no "." in the filename we
	// will assume it is a directory.

	if (URL != "") {
		goodURL += URL;
		if (!URL.contains("."))
			goodURL += "/";
	}
	return(goodURL);
}

// This turns remote addresses into local filename addresses
//
// Since we don't cache anything but "http://" we will just
// ignore those.

String RemoteToLocal(String URL, String CacheDir) // vlocal
{
	if(verbose & V_DEBUG)
		cerr << "RemoteToLocal: URL=[" << URL 
		     << "] CacheDir=[" << CacheDir << "]" << endl;
	if (URL.index("http://") == 0) {
		URL = RemoteToRemote(URL);
		URL = CacheDir + URL.after("http://");
		if (URL [ (int)URL.length() - 1 ] == '/')
			URL += "index.html";
	} else {
		// If it isn't an http: reference,
		// no local address exists.
		return ("");
	}
	
	return(URL);
}

int RelativelyLocal(String x, String y)
{
	String common = common_prefix(x,y);
	assert(common.index("http://") == 0);
	
	common = common.after("http://");

	// Two URL's are local if they have
	// the same info up to at least one "/"
	// ie they share the hostname.
	
	// This is very simplistic, but should serve
	// as a basis.
	
	// It could be modified to give more locality
	// ie, only local to a specific directory and 
	// all under it.
	//
	// One way would be to have a command line
	// option for a locality # and compare that
	// # to the # of "/" in the common prefix.
	// 
	// # == 1 is equiv. to current behavior.
	
	if(common.contains("/"))
		return (1);
	
	return(0);
}

