#if !defined(__univopt_h)
#define __univopt_h

#include "typedopt.h"
#include "stringcol.h"
#include <set>
#include <string>

class CUnivOptions : public COptions<std::string>, 
    public COptions<TStringCol>,
    public COptions<int>,
    public COptions<double>,
    public COptions<bool>
{
private:
    std::set<std::string> SectList;
    char *LastErrorMessage;
protected:
    int ComposedKeys;

public:
    CUnivOptions();
    virtual ~CUnivOptions();

    // returns empty string OK, otherwise key which has
    // initial invalid value
    virtual std::string FirstInvalidKey();

    void WatchSection(const char *SectName);
    void ChangeWatchedSections(const TStringCol &ToList);

    virtual bool HasSection(const char *SectName);

    inline void Add(const char *Key, const char *Value);
    inline void Add(const char *Key, const std::string &Value);
    inline void Add(const char *Key,
	COptions<std::string>::FCompute Compute);
    inline void Add(const char *Key, const TStringCol &Value);
    inline void Add(const char *Key,
       	COptions<TStringCol>::FCompute Compute);
    inline void Add(const char *Key, int Value);
	// no need to pass int by reference
    inline void Add(const char *Key, COptions<int>::FCompute Compute);
    inline void Add(const char *Key, double &Value);	
    inline void Add(const char *Key, COptions<double>::FCompute Compute);

    inline int Override(const char *Section, 
	const char *Key, 
	const std::string &Value);
    inline int Override(const char *Section,
	const char *Key, 
	const TStringCol &Value);
    inline int Override(const char *Section,
	const char *Key, 
	int Value);
    inline int Override(const char *Section,
	const char *Key, 
	const double &Value);

    // COptions<std::string>::Get is called most often
    inline std::string Get(const char *Key) const;
    inline TStringCol Get_TStringCol(const char *Key) const;
    inline int Get_int(const char *Key) const;
    inline double Get_double(const char *Key) const;
    inline bool Get_bool(const char *Key) const;

    inline bool CanAdd_string(const std::string &Key);
    inline bool CanAdd_TStringCol(const std::string &Key);
    inline bool CanAdd_int(const std::string &Key);
    inline bool CanAdd_double(const std::string &Key);
    inline bool CanAdd_bool(const std::string &Key);

    virtual std::string GetKey(const char *Section, const char *Key) const;

    char *UnknownKeyError(const char *Key);
    int GetComposedMode() { return ComposedKeys; }
    void SetComposedMode(int ComposedMode) { ComposedKeys = ComposedMode; }

    virtual char *AllocMungedSectionName(char *InSection);
};

inline void CUnivOptions::Add(const char *Key, const char *Value)
{
    Add(Key, std::string(Value));
}

inline void CUnivOptions::Add(const char *Key,
    const std::string &Value)
{   
    typedef void (COptions<std::string>::*FAdd)(
	const char *, const std::string &);

    FAdd ptr = &(COptions<std::string>::Add);
    (this->*ptr)(Key, Value); 
}

inline void CUnivOptions::Add(const char *Key,
    COptions<std::string>::FCompute Compute)
{ 
    typedef void (COptions<std::string>::*FAdd)(
	const char *, COptions<std::string>::FCompute);

    FAdd ptr = &(COptions<std::string>::Add);
    (this->*ptr)(Key, Compute); 
}

inline void CUnivOptions::Add(const char *Key,
    const TStringCol &Value)
{
    typedef void (COptions<TStringCol>::*FAdd)(
	const char *, const TStringCol &);

    FAdd ptr = &(COptions<TStringCol>::Add);
    (this->*ptr)(Key, Value); 
}

inline void CUnivOptions::Add(const char *Key,
    COptions<TStringCol>::FCompute Compute)
{ 
    typedef void (COptions<TStringCol>::*FAdd)(
	const char *, COptions<TStringCol>::FCompute);

    FAdd ptr = &(COptions<TStringCol>::Add);
    (this->*ptr)(Key, Compute); 
}

inline void CUnivOptions::Add(const char *Key, int Value)
{
    typedef void (COptions<int>::*FAdd)(
	const char *, const int &);

    FAdd ptr = &(COptions<int>::Add);
    (this->*ptr)(Key, Value); 
}

inline void CUnivOptions::Add(const char *Key,
    COptions<int>::FCompute Compute)
{ 
    typedef void (COptions<int>::*FAdd)(
	const char *, COptions<int>::FCompute);

    FAdd ptr = &(COptions<int>::Add);
    (this->*ptr)(Key, Compute); 
}

inline void CUnivOptions::Add(const char *Key, double &Value)
{
    typedef void (COptions<double>::*FAdd)(
	const char *, const double &);

    FAdd ptr = &(COptions<double>::Add);
    (this->*ptr)(Key, Value); 
}

inline void CUnivOptions::Add(const char *Key,
    COptions<double>::FCompute Compute)
{ 
    typedef void (COptions<double>::*FAdd)(
	const char *, COptions<double>::FCompute);

    FAdd ptr = &(COptions<double>::Add);
    (this->*ptr)(Key, Compute); 
}

inline int CUnivOptions::Override(const char *Section,
    const char *Key, 
    const std::string &Value)
{	
    return COptions<std::string>::Override(Section, Key, Value); 
}

inline int CUnivOptions::Override(const char *Section,
    const char *Key, 
    const TStringCol &Value)
{	
    return COptions<TStringCol>::Override(Section, Key,
	Value); 
}

inline int CUnivOptions::Override(const char *Section,
    const char *Key, 
    int Value)
{ 
    return COptions<int>::Override(Section, Key, Value); 
}

inline int CUnivOptions::Override(const char *Section,
    const char *Key, 
    const double &Value)
{ 
    return COptions<double>::Override(Section, Key, Value); 
}

inline std::string CUnivOptions::Get(const char *Key) const
{ 
    return (this->*(&COptions<std::string>::Get))(Key); 
}

inline TStringCol CUnivOptions::Get_TStringCol(const char *Key) const
{ 
    return (this->*(&COptions<TStringCol>::Get))(Key); 
}

inline int CUnivOptions::Get_int(const char *Key) const
{ 
    return (this->*(&COptions<int>::Get))(Key); 
}

inline double CUnivOptions::Get_double(const char *Key) const
{ 
    return (this->*(&COptions<double>::Get))(Key); 
}

inline bool CUnivOptions::Get_bool(const char *Key) const
{ 
    return (this->*(&COptions<bool>::Get))(Key); 
}

inline bool CUnivOptions::CanAdd_string(const std::string &Key)
{ 
    return COptions<std::string>::CanAdd(Key); 
}

inline bool CUnivOptions::CanAdd_TStringCol(const std::string &Key)
{ 
    return COptions<TStringCol>::CanAdd(Key); 
}

inline bool CUnivOptions::CanAdd_int(const std::string &Key)
{ 
    return COptions<int>::CanAdd(Key); 
}

inline bool CUnivOptions::CanAdd_double(const std::string &Key)
{ 
    return COptions<double>::CanAdd(Key); 
}

inline bool CUnivOptions::CanAdd_bool(const std::string &Key)
{ 
    return COptions<bool>::CanAdd(Key); 
}

#endif

