#include "univopt.h"
#include "composed.h"
#include "rferr.h"
#include <algo.h>
#include <assert.h>

using std::string;

CUnivOptions::CUnivOptions():
    LastErrorMessage(NULL),
    ComposedKeys(0)
{
}

CUnivOptions::~CUnivOptions()
{
    if (LastErrorMessage)
        free(LastErrorMessage);
}

char *CUnivOptions::UnknownKeyError(const char *Key)
{
    char *Message = OE_INVALKEY;

    if (LastErrorMessage)
        return Message;

    LastErrorMessage = (char *)malloc(strlen(Message) + 1 + strlen(Key) + 1);
    if (!LastErrorMessage)
        return Message;
    
    strcpy(LastErrorMessage, Message);
    strcat(LastErrorMessage, " ");
    strcat(LastErrorMessage, Key);
    return LastErrorMessage;
}

string CUnivOptions::FirstInvalidKey()
{
    return string("");
}

void CUnivOptions::WatchSection(const char *SectName)
{
    assert(SectName != NULL);
    SectList.insert(string(SectName));
}

bool CUnivOptions::HasSection(const char *SectName)
{
    string Name;
    if (SectName)
	Name = SectName;
    
    return SectList.find(Name) != SectList.end();
}

string CUnivOptions::GetKey(const char *Section,
    const char *Key) const
{
    if (!ComposedKeys)
	return string(Key);
    else
    {   string s;
        if (Section)
	    s = Section;
	return GetLongOptionKey(s, Key);
    }
}

void CUnivOptions::ChangeWatchedSections(const TStringCol &ToList)
{
    SectList.clear();
    for (TStringCol::const_iterator i = ToList.begin();
	i != ToList.end();
	++i)
	SectList.insert(*i);
}

char *CUnivOptions::AllocMungedSectionName(char *InSection)
{
    return InSection;
}
