#if !defined(statrng_h)
#define statrng_h

#include <string>

using std::string;

class StatusRange
{
public:
    StatusRange();
    StatusRange(short front, short back);
    StatusRange(const StatusRange &other);
    // default assignement operator used

    bool IsInRange(int status) const;

private:
    short Front;
    short Back;
};

void ParseExpectedUrlStatus(const string &url_range,
    string &url,
    short &front,
    short &back);

class UrlStatusFormatException
{
public:
    UrlStatusFormatException(const string &url_range):
	UrlRange(url_range) { }

    const string UrlRange;
};


#endif
