#include "statrng.h"
#include <string.h>
#include <ctype.h>

StatusRange::StatusRange():
    Front(200),
    Back(200)
{
}

StatusRange::StatusRange(short front, short back):
    Front(front),
    Back(back)
{
}

StatusRange::StatusRange(const StatusRange &other):
    Front(other.Front),
    Back(other.Back)
{
}

bool StatusRange::IsInRange(int status) const
{
    return Front <= status && status <= Back;
}

void ParseExpectedUrlStatus(const string &url_range,
    string &url,
    short &front,
    short &back)
{
    const char *p = strrchr(url_range.c_str(), '=');
    if (!p || p == url_range.c_str())
	throw UrlStatusFormatException(url_range);

    url = string(url_range.c_str(), p);

    char hundert = p[1];
    if (!(hundert >= '1' && hundert <= '9'))
	throw UrlStatusFormatException(url_range);

    char ten = tolower(p[2]);
    if (!(ten == 'x' || isdigit(ten)))
	throw UrlStatusFormatException(url_range);
    
    char one = tolower(p[3]);
    if (one == 0)
	one = 'x';
    else
    {   if (p[4] != 0)	
	    throw UrlStatusFormatException(url_range);
    }
    if (ten == 'x')
    {   if (one != 'x')
	    throw UrlStatusFormatException(url_range);
    }
    else
    {   if (!isdigit(one))
	    throw UrlStatusFormatException(url_range);
    }

    front = 100 * (hundert - '0');
    back = front;

    if (ten == 'x')
        back += 99;
    else
    {   front += 10 * (ten - '0') + (one - '0');
        back = front;
    }
}

    
