#if !defined(rxw_h)
#define rxw_h

#include <string>

class CRegexLetter;

class CRegex
{
public:
    static const int DefaultCompFlags;
    static const int DefaultExecFlags;

    // Including regex.h (t. lord	Wed Sep 23 18:20:57 1992) 
    // into C++ modules makes problems. Define REG_ flags so that
    // clients don't have to do it.
    static const int Extended;
    static const int Icase;
    static const int Newline;
    static const int Nosub;

public:
    CRegex();
    CRegex(const std::string &Regex,
	int aCompFlags = DefaultCompFlags,
	int aExecFlags = DefaultExecFlags);
    CRegex(const CRegex &Other);
    ~CRegex();
    CRegex &operator = (const CRegex &Other);

    int operator == (const CRegex &Other) const
        { return Letter == Other.Letter; }

    int Matches(const char *String, int &From, int &To) const;
    int IsEmpty() const { return Letter == NULL; }

private:
    CRegexLetter *Letter; // can be NULL
};

#endif
