#include "rxw.h"
#include "rxletter.h"
#include <regex.h>

const int CRegex::DefaultCompFlags = REG_EXTENDED | REG_NEWLINE;
const int CRegex::DefaultExecFlags = REG_NOTBOL | REG_NOTEOL;

const int CRegex::Extended = REG_EXTENDED;
const int CRegex::Icase = REG_ICASE;
const int CRegex::Newline = REG_NEWLINE;
const int CRegex::Nosub = REG_NOSUB;

CRegex::CRegex():
    Letter(NULL)
{
}

CRegex::CRegex(const std::string &Regex,
    int aCompFlags,
    int aExecFlags):
    Letter(NULL)
{
    if (!Regex.empty())
        Letter = new CRegexLetter(Regex, aCompFlags, aExecFlags);
}

CRegex::CRegex(const CRegex &Other):
    Letter(Other.Letter)
{
    if (Letter)
        Letter->AddRef();
}

CRegex::~CRegex()
{
    if (Letter)
        Letter->DelRef();
}

CRegex &CRegex::operator = (const CRegex &Other)
{
    if (Other.Letter)
        Other.Letter->AddRef();
    if (Letter)
        Letter->DelRef();
    Letter = Other.Letter;
    return *this;
}

int CRegex::Matches(const char *String, int &From, int &To) const
{
    if (!Letter)
    {   From = To = -1;
        return 0;
    }
    return Letter->Matches(String, From, To);
}
