#include "rxletter.h"
#include <assert.h>
#include "excpt.h"

CRegexLetter::CRegexLetter(const std::string &Source,
    int aCompFlags,
    int aExecFlags):
    Count(1),
    ExecFlags(aExecFlags)
{
    assert(!Source.empty());
    int r = regcomp(&Regex, Source.c_str(), aCompFlags);
    if (r)
    {   char ErrBuf[100];
        regerror(r, &Regex, ErrBuf, 100);
        throw RegexParseException(Source, ErrBuf);
    }
}

CRegexLetter::~CRegexLetter()
{
    regfree(&Regex);
}

void CRegexLetter::AddRef()
{
    ++Count;
}

void CRegexLetter::DelRef()
{
    if (--Count <= 0)
        delete this;
}

int CRegexLetter::Matches(const char *String, int &From, int &To) const
{   regmatch_t Match;

    if (regexec(&Regex, String, 1, &Match, ExecFlags))
    {   From = To = -1;
        return 0;
    }
    else
    {   From = Match.rm_so;
        To = Match.rm_eo;
        return 1;
    }
}

