#if !defined(result_h)
#define result_h

#include <string>
#include <set>
#include <vector>
#include <time.h>

#include "errdesc.h"

using namespace std;

class CLinkOptions;

class Result
{
public:
    Result(CLinkOptions &opt,
	time_t start_time,
	time_t end_time);

    void Add(const string &uri,
	const set<string> &deps,
	int status);

    void Send();

private:
    ErrorDescription ErrDesc;
    string Body;
    time_t StartTime;
    time_t EndTime;
    CLinkOptions &Options;
    const string ParaFormat;
    const string ParaDivider;
    const string DepFormat;
    const string DepDivider;

    string FormatDeps(const set<string> &deps) const;
};

#endif
