#include "result.h"
#include "linkopt.h"
#include "olink.h"
#include "messform.h"
#include "pipe.h"
#include <stdio.h>
#include <stdlib.h>

class ResultHead
{
public:
    ResultHead(const char *templ, CLinkOptions &opt);

    string GetHead(time_t start_time,
	time_t end_time);


private:
    const string PrologTemplate;
    const string TimeFormat;
    const string UrlFormat;
    const string UrlDivider;

    const TStringCol Urls;

    string FormatTime(time_t t);
    string FormatUrls();
};

Result::Result(CLinkOptions &opt,
    time_t start_time,
    time_t end_time):
    StartTime(start_time),
    EndTime(end_time),
    Options(opt),
    ParaFormat(opt.Get(o_paragraph_template)),
    ParaDivider(opt.Get(o_paragraph_divider)),
    DepFormat(opt.Get(o_dependency_template)),
    DepDivider(opt.Get(o_dependency_divider))
{
}

void Result::Add(const string &uri,
    const set<string> &deps,
    int status)
{
    if (!Body.empty())
	Body += ParaDivider;

    MessageFormat paragraph(ParaFormat);
    paragraph << uri << FormatDeps(deps) << abs(status) << 
	ErrDesc.GetDesc(status);
    Body += paragraph.GetMessage();
}

void Result::Send()
{
    const char *ht = o_prolog_template;
    if (Body.empty())
    {   if (!Options.Get_bool(o_send_ok))
	    return;
        else
	    ht = o_ok_template;
    }

    ResultHead result_head(ht, Options);
    string message = result_head.GetHead(StartTime, EndTime) + Body;
    Pipe messaging_process(Options.Get(o_message_pipe), "w");
    messaging_process.Write(message.c_str(), message.size());
}

string Result::FormatDeps(const set<string> &deps) const
{
    string out;
    for (set<string>::const_iterator i = deps.begin();
	i != deps.end();
	++i)
    {   if (!out.empty())
	    out += DepDivider;
        MessageFormat f(DepFormat);
	f << *i;
        out += f.GetMessage();
    }
    return out;
}

ResultHead::ResultHead(const char *templ,
    CLinkOptions &opt):
    PrologTemplate(opt.Get(templ)),
    TimeFormat(opt.Get(o_time_template)),
    UrlFormat(opt.Get(o_url_template)),
    UrlDivider(opt.Get(o_url_divider)),
    Urls(opt.Get_TStringCol(o_start_url))
{
}

string ResultHead::GetHead(time_t start_time, time_t end_time)
{
    MessageFormat head(PrologTemplate);
    head << FormatTime(start_time) << FormatTime(end_time) <<
	FormatUrls();
    return head.GetMessage();
}

string ResultHead::FormatTime(time_t t)
{
    struct tm *p = localtime(&t);
    MessageFormat f(TimeFormat);
    f << p->tm_sec << p->tm_min << p->tm_hour << 
	p->tm_mday << (p->tm_mon + 1) << p->tm_year <<
	p->tm_wday << p->tm_yday << p->tm_isdst;
    return f.GetMessage();
}

string ResultHead::FormatUrls()
{
    string out;
    for (TStringCol::const_iterator i = Urls.begin();
	i != Urls.end();
	++i)
    {   if (!out.empty())
	    out += UrlDivider;
        MessageFormat f(UrlFormat);
	f << *i;
        out += f.GetMessage();
    }
    return out;
}
