#if !defined(redirector_h)
#define redirector_h

#include <string>
#include <vector>
#include <set>

class CLinkOptions;

class Redirector
{
public:
    Redirector(CLinkOptions &opt);

    bool IsRedirectworthy(const string &uri);
    void FreeRedirectionChain(const string &uri);
	// Does nothing for uris which were not, in fact,
        // redirected. Now there can be at most one redirection -
        // but it could be extended...

private:
    vector<string> RedirectingRealms;
    set<string> ActiveRedirections;

    static bool HasHead(const string &uri, const char *head);
};

#endif
