#include "redirector.h"
#include "linkopt.h"
#include "olink.h"
#include <assert.h>

Redirector::Redirector(CLinkOptions &opt):
    RedirectingRealms(opt.Get_TStringCol(o_tame_redirect))
{
}

bool Redirector::IsRedirectworthy(const string &uri)
{
    for (vector<string>::const_iterator i = RedirectingRealms.begin();
	i != RedirectingRealms.end();
	++i)
    {   if (HasHead(uri, i->c_str()))
        {   if (ActiveRedirections.find(uri) != ActiveRedirections.end())
		return false;
	    else
	    {   ActiveRedirections.insert(uri);
	        return true;
	    }
	}
    }

    return false;
}

void Redirector::FreeRedirectionChain(const string &uri)
{
    set<string>::iterator i = ActiveRedirections.find(uri);
    if (i != ActiveRedirections.end())
	ActiveRedirections.erase(i);
}

bool Redirector::HasHead(const string &uri, const char *head)
{
    assert(head != 0);

    size_t l = strlen(head);
    if (uri.length() < l)
	return false;

    for (int i = 0; i < l; ++i)
    {   if (uri[i] != head[i])
	    return false;
    }

    return true;
}
