#if !defined(progress_h)
#define progress_h

#include <string>
#include <map>
#include <set>

extern "C"
{
#undef VERSION
#undef PACKAGE
#include "wwwconf.h"
#include "WWWLib.h"
}
#include "database.h"

class Progress
{
public:
    Progress(const Database &db);

    bool Register(const string &uri,
	const string &dependency);

    void Load(HTAnchor *anchor, HTRequest *request);
    void Load(const char *url, HTRequest *request);

    void Finish();
	// may break the event loop

private:
    int Outstanding;
    Database Db;
};

class LoadFailureException
{
public:
    LoadFailureException(const char *uri):Uri(uri ? uri : "") { }

    const string Uri;
};

#endif
