#include "progress.h"
extern "C"
{
#include "HTAccess.h"
#include "HTEvtLst.h"
}
#include "database.h"

Progress::Progress(const Database &db):
    Db(db),
    Outstanding(0)
{
}

bool Progress::Register(const string &uri,
    const string &dependency)
{
    bool r = Db.InsertFound(uri);
    Db.InsertLink(dependency, uri);
    return r;
}

void Progress::Load(HTAnchor *anchor, HTRequest *request)
{    
    if (!HTLoadAnchor(anchor, request))
	throw LoadFailureException(HTAnchor_address(anchor));
    ++Outstanding;
}

void Progress::Load(const char *url, HTRequest *request)
{
    if (!HTLoadAbsolute(url, request))
	throw LoadFailureException(url);
    ++Outstanding;
}

void Progress::Finish()
{
    if (--Outstanding <= 0)
	HTEventList_stopLoop();
}

