#if !defined(pipe_h)
#define pipe_h

#include <string>
#include <stdio.h>

using namespace std;

// wrapper for popen
class Pipe
{
public:
    Pipe(const string &command, const char *type);
    ~Pipe();

    void Write(const void *buffer, size_t size);

private:
    FILE *FilePipe;
};

class OpenPipeException
{
public:
    OpenPipeException(const string &command, const char *type):
	Command(command), Type(type)
	{
	}

    const string Command;
    const string Type;
};

class WritePipeException
{
public:
    WritePipeException() { }
};

#endif
