#include "pipe.h"

Pipe::Pipe(const string &command, const char *type):
    FilePipe(popen(command.c_str(), type))
{
    if (!FilePipe)
	throw OpenPipeException(command, type);
}

Pipe::~Pipe()
{
    pclose(FilePipe);
}

void Pipe::Write(const void *buffer, size_t size)
{
    if (fwrite(buffer, size, 1, FilePipe) != 1)
	throw WritePipeException();
}

