#include "univopt.h"
#include <assert.h>

extern "C"
{
#include "paction.h"
#include "rferr.h"
};

using std::string;

CUnivOptions *PAGlobOptions = NULL;
    // set by override.cpp

static char *ReportAmbiguity();

char *AddInt(char *Section, char *Key, int Value)
{
    try
    {   if (!PAGlobOptions->HasSection(Section))
	    return NULL;

        if (PAGlobOptions->Override(Section, Key, Value))
	{   // it's not int; it can be double
	    double DoubleVal = Value;
	    if (PAGlobOptions->Override(Section, Key, DoubleVal))
		return PAGlobOptions->UnknownKeyError(Key);
	}
	else
	{   // if it's int, it can't be double
	    if (!PAGlobOptions->CanAdd_double(Key))
		return ReportAmbiguity();
	}

	return NULL;
    }
    catch (...)
    {   return OE_GENERIC;
    }
}

char *AddBool(char *Section, char *Key, int Value)
{
    try
    {   if (!PAGlobOptions->HasSection(Section))
	    return NULL;

        if ((PAGlobOptions->*&COptions<bool>::Override)(
	        Section, Key, !!Value))
	    return PAGlobOptions->UnknownKeyError(Key);

	return NULL;
    }
    catch (...)
    {   return OE_GENERIC;
    }
}

char *AddStr(char *Section, char *Key, char *Value)
{
    try
    {   assert(Value != NULL);
        string ValueStr = Value;
	free(Value);

	if (!PAGlobOptions->HasSection(Section))
	    return NULL;

	if (PAGlobOptions->Override(Section, Key, ValueStr))
        {   // it's not a string; it can be a string list
	    TStringCol List;
	    List.push_back(ValueStr);
	    if (PAGlobOptions->Override(Section, Key, List))
		return PAGlobOptions->UnknownKeyError(Key);
	}
	else
	{   // if it's string, it can't be string list
	    if (!PAGlobOptions->CanAdd_TStringCol(Key))
		return ReportAmbiguity();
        }

	return NULL;
    }
    catch (...)
    {   return OE_GENERIC;
    }
}

char *AddList(char *Section, char *Key, SStrList *Value)
{
    try
    {   if (!PAGlobOptions->HasSection(Section))
	    return NULL;

        TStringCol List;
	List.reserve(Value->Count);
	for (int i = 0; i < Value->Count; i++)
	    List.push_back(Value->List[i]);

	if (PAGlobOptions->Override(Section, Key, List))
	    return PAGlobOptions->UnknownKeyError(Key);

	return NULL;
    }
    catch (...)
    {   return OE_GENERIC;
    }
}

char *AddDouble(char *Section, char *Key, double Value)
{
    try
    {   if (PAGlobOptions->HasSection(Section))
	{   if (PAGlobOptions->Override(Section, Key, Value))
	        return PAGlobOptions->UnknownKeyError(Key);
	}
        return NULL;
    }
    catch (...)
    {   return OE_GENERIC;
    }
}

char *AllocMungedSectionName(char *InSection)
{
    return PAGlobOptions->AllocMungedSectionName(InSection);
}

static char *ReportAmbiguity()
{
    assert(0); 
	// user of options library (the application, not
        // the end user) must fix its value names
    return OE_AMBIGKEY;
}
