#include "override.h"
#include "excpt.h"
#include <string>
#include <set>

extern "C"
{
#include "curstate.h"
#include "rferr.h"
};

#include <stdio.h>
#include <assert.h>

extern "C"
{
extern int yyparse(void);
extern FILE *yyin;
};

extern CUnivOptions *PAGlobOptions;

void OverrideStringCollection(CUnivOptions &Options,
    set<string> &KnownNames,
    const std::string &Name,
    const std::string &Value);

string GetCommandLineForm(const string &Key);

void OverrideOptions(CUnivOptions &Options,
    const char *FName)
{
    if (!OverrideCond(Options, FName))
	throw FileOpenException(std::string(FName));
}

bool OverrideCond(CUnivOptions &Options,
    const char *FName)
{   FILE *h;

    rfline = 1;
    h = fopen(FName, "r");
    if (!h)
	return false;

    yyin = h;
    PAGlobOptions = &Options;
    if ((rferror = InitState()) == NULL)
    {	yyparse();
        DoneState();
    }
    fclose(h);
    
    if (rferror)
	throw FileParseException(std::string(FName),
	    rfline,
	    std::string(rferror));

    return true;
}

std::string ConvertName(const char *Arg)
{
    std::string Out = Arg;
    for (int i = 0; i < Out.length(); ++i)
    {   if (Out[i] == '-')
	    Out[i] = '_';
    }
    return Out;
}

string GetCommandLineForm(const string &Key)
{
    string out = "--";
    out += Key;
    for (int i = 2; i < out.length(); ++i)
    {   if (out[i] == '_')
	    out[i] = '-';
    }
    return out;
}

// for strings and string collections only - numbers
// (int & double) on command line not supported (yet?)
void Override(CUnivOptions &Options,
    set<string> &KnownNames,
    const std::string &Name,
    const std::string &Value)
{
    if (!Options.Override(NULL, Name.c_str(), Value))
    {   if (KnownNames.find(Name) != KnownNames.end())
	    throw MultipleDefinitionException(
		GetCommandLineForm(Name));
        else
	    KnownNames.insert(Name);
    }
    else
	OverrideStringCollection(Options, KnownNames,
	        Name, Value);
}

void OverrideStringCollection(CUnivOptions &Options,
    set<string> &KnownNames,
    const std::string &Name,
    const std::string &Value)
{
    if (Options.CanAdd_TStringCol(Name.c_str()))
	throw UndefinedKeyException(GetCommandLineForm(Name));

    TStringCol col;
    if (KnownNames.find(Name) == KnownNames.end())
	KnownNames.insert(Name);
    else
	col = Options.Get_TStringCol(Name.c_str());
    col.push_back(Value);
    int known_ret = Options.Override(NULL, Name.c_str(), col);
    assert(!known_ret);
}

void OverrideOptions(CUnivOptions &Options,
    char *ArgTail[],
    const std::string &DefaultName)
{
    set<string> KnownNames;

    bool Implicit = true;
    std::string Name = DefaultName;

    while (*ArgTail)
    {   if (Implicit &&
	    (*ArgTail)[0] == '-')
	{   if ((*ArgTail)[1] == '-')
	    {   Name = ConvertName((*ArgTail) + 2);
	        // type bool doesn't have an argument and defaults
	        // to true
	        if ((Options.*&COptions<bool>::Override)(NULL, 
		        Name.c_str(), true))
		    Implicit = false;
		else
		{   Implicit = true;
		    Name = DefaultName;
		}
	    }
	    else
	    {   throw UndefinedKeyException(string("-"));
		    // short-form options not supported (yet?)
#if 0
		int used = OverrideShort(Options,
		    (*ArgTail) + 1,
		    ArgTail + 1);
	        ArgTail += used;
#endif
	    }
	}
        else
	{   Override(Options,
	        KnownNames,
	        Name,
	        std::string(*ArgTail));
  	    Implicit = true;
	    Name = DefaultName;
	}
        ++ArgTail;
    }

    if (!Implicit)
    {   if (Options.CanAdd_string(Name) &&
	    Options.CanAdd_TStringCol(Name))
	    throw UndefinedKeyException(GetCommandLineForm(Name));
        else
	    throw MissingValueException(GetCommandLineForm(Name));
    }
}
    
