#if !defined(output_h)
#define output_h

#include <string>
#include <syslog.h>

using std::string;

class Output
{
public:
    static void SetName(const char *name);
    static Output &GetSink(int priority = LOG_ERR);

    Output &operator << (const string &var);
    Output &operator << (const char *var);
    Output &operator << (int var);
    Output &operator << (char var);
    
private:
    static string Name;
    static int Priority;
    string Buffer;

    Output();
    void Flush();
    void PrintLine(const char *begin, const char *end);
};

#endif
