#include "output.h"
#include <stdio.h>
#include <iostream>
#include <assert.h>

string Output::Name("noname");
int Output::Priority = LOG_ERR;

Output::Output()
{
}

Output &Output::GetSink(int priority)
{
    static Output singleton;
    Output::Priority = priority;
    return singleton;
}

Output &Output::operator << (const string &var)
{
    Buffer += var;
    Flush();
    return *this;
}

Output &Output::operator << (const char *var)
{
    Buffer += var ? var : "<NULL>";
    Flush();
    return *this;
}

Output &Output::operator << (int var)
{
    char Str[100];
    sprintf(Str, "%d", var);
    Buffer += Str;
    // no Flush - number can't contain \n
    return *this;
}

Output &Output::operator << (char var)
{
    Buffer += var;
    Flush();
    return *this;
}

void Output::Flush()
{
    const char *p = Buffer.c_str();
    const char *q;
    while ((q = strchr(p, '\n')) != NULL)
    {    PrintLine(p, q);
         p = q + 1;
    }

    if (p != Buffer.c_str())
    {   string n = p;
        Buffer = n;
    }
}

void Output::PrintLine(const char *begin, const char *end)    
{
    string ln(begin, end);
    if (ln.empty())
	return;

    if (Priority == LOG_INFO)
	cout << Name << ": " << ln << '\n';
    else
    {   cerr << Name << ": " << ln << '\n';
        syslog(Priority, "%s", ln.c_str());
    }
}

void Output::SetName(const char *name)
{
    assert(name != NULL);
    Name = name;
    openlog(name, LOG_CONS, LOG_USER);
}

