#include "optval.h"
#include "rferr.h"

#include <stdlib.h>
#include <string.h>

SStrList *InitStrList()
{   SStrList *self;

    if ((self = (SStrList *)malloc(sizeof(SStrList))) == NULL)
	   return NULL;

    self->Count = 0;
    self->List = NULL;
    return self;
}

void DoneStrList(SStrList *self)
{   int i;

    for (i = 0; i < self->Count; i++)
        free((self->List)[i]);
    if (self->List)
        free(self->List);
    free(self);
}

char *InsertItem(SStrList *self, char *Item)
{   int Count;
    char **List;
//    int Len;

    Count = self->Count + 1;
    if ((List = (char **)malloc(Count * sizeof(char *))) == NULL)
	   goto ERREXIT;    
    List[Count - 1] = NULL;

    if (self->List)
        memcpy(List, self->List, self->Count * sizeof(char *));

/*    Len = strlen(Item) + 1;
    if ((List[Count - 1] = (char *)malloc(Len)) == NULL)
	   goto ERREXIT;    
    memcpy(List[Count - 1], Item, Len);*/
    List[Count - 1] = Item;

    if (self->List)
        free(self->List);
    self->List = List;
    self->Count = Count;
    return 0;

ERREXIT:
    if (List)
    {   if (List[Count - 1])
	       free(List[Count - 1]);
	   free(List);
    }	  
    return OE_GENERIC;
}



