%{

#include "paction.h"
#include "curstate.h"
#include "rferr.h"

%}

%union
{  int ival;
   char *sval;
   double dval;
   char *serr;
}

%token <sval> SECTNAME
%token <sval> KEY
%token <ival> VALINT
%token <ival> VALBOOL
%token <sval> VALSTR
%token <dval> VALDOUBLE
%token <serr> INVALIDSTR

%%

config: section_body section_list
   ;

section_list:
   | section_list section
   ;

section: section_name section_body
   ;

section_name: SECTNAME { 
    char *err = $1 == NULL ? OE_GENERIC : SetCurrentSection($1);
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };

section_body:
   | section_body keyvalue
   ;

keyvalue: key '=' value
   ;

value: int_value | bool_value | str_value | str_list | float_value
   ;

key: KEY { 
    char *err = $1 == NULL ? OE_GENERIC : SetCurrentKey($1);
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };
        
int_value: VALINT { 
    char *err = AddInt(GetCurrentSection(), GetCurrentKey(), $1);
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };   

bool_value: VALBOOL { 
    char *err = AddBool(GetCurrentSection(), GetCurrentKey(), $1);
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };   

str_value: VALSTR {
    char *err = $1 == NULL ? OE_GENERIC : AddStr(GetCurrentSection(), 
            GetCurrentKey(), $1);
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };      

str_value: INVALIDSTR {
    yyerror($1);
    YYERROR;
   };

str_list: str_list_item str_list_item str_list_tail {   
    char *err = AddList(GetCurrentSection(), GetCurrentKey(), GetList());
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
    err = ResetList();
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };

float_value: VALDOUBLE { 
    char *err = AddDouble(GetCurrentSection(), GetCurrentKey(), $1); 
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };

str_list_item: VALSTR { 
    char *err = $1 == NULL ? OE_GENERIC : InsertItem(GetList(), $1); 
    if (err)
    {   yyerror(err);
	   YYERROR;
    }	   
   };   

str_list_tail:
   | str_list_tail str_list_item
   ;

%%

int yywrap()
{
    return 1;
}







