%{
#include "optrftab.h"
#include "rferr.h"

#include <stdlib.h>
#include <string.h>

static char *AllocSectName(void);
static char *AllocKey(void);
static char *AllocStr(void);
static void AddChar(char c);

#define STRING_BUFFER_SIZE	512
char StringBuffer[STRING_BUFFER_SIZE];

%}

%x STRING_MODE

ID [a-zA-Z][a-zA-Z0-9_]*

%%

^\[[a-zA-Z0-9_\.+-]*\] {
    yylval.sval = AllocSectName();
    return SECTNAME; 
   }

^{ID} { 
    yylval.sval = AllocKey();
    return KEY; 
   }

-?[0-9]+ { yylval.ival = atoi(yytext); return VALINT; }

yes { yylval.ival = 1; return VALBOOL; }

no { yylval.ival = 0; return VALBOOL; }

-?([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)? { yylval.dval = atof(yytext); 
    return VALDOUBLE; }

"\"" {
   BEGIN STRING_MODE;
   StringBuffer[0] = 0;
   }

[ \t] /* skip */;

^#.*\n { rfline++; }

\n { rfline++; }

"$" { 
    return 0; 
    }

. { return yytext[0]; }

<STRING_MODE>\n {
   yylval.serr = OE_NEWLINE;
   return INVALIDSTR;
   }

<STRING_MODE>\" {
   BEGIN INITIAL;
   yylval.sval = AllocStr();
   return VALSTR;
   }

<STRING_MODE>"\\\\" {
   AddChar('\\');
   }

<STRING_MODE>"\\\"" {
   AddChar('\"');
   }

<STRING_MODE>"\\n" {
   AddChar('\n');
   }

<STRING_MODE>"\\t" {
   AddChar('\t');
   }

<STRING_MODE>\\ {
   yylval.serr = OE_QUOTEBSLASH;
   return INVALIDSTR;
   }

<STRING_MODE>"\"\"" {
   yylval.serr = OE_QUOTEQUOTE;
   return INVALIDSTR;
   }

<STRING_MODE>. {
   AddChar(yytext[0]);
   }

%%

static char *AllocSectName()
{   char *src;
    char *sect;
    char *p;

    src = yytext + 1;
    if ((sect = (char *)malloc(strlen(src) + 1)) == NULL)
	   return NULL;

    strcpy(sect, src);
    p = strchr(sect, ']');
    *p = 0;
    return sect;
}

static char *AllocKey()
{   char *key;

    if ((key = (char *)malloc(strlen(yytext) + 1)) == NULL)
	   return NULL;

    strcpy(key, yytext);
    return key;
}

static char *AllocStr()
{   char *ns;

    if ((ns = (char *)malloc(strlen(StringBuffer) + 1)) == NULL)
	   return NULL;

    strcpy(ns, StringBuffer);
    return ns;
}

static void AddChar(char c)
{   int l;

    l = strlen(StringBuffer);
    if (l >= STRING_BUFFER_SIZE - 1)
        return;

    StringBuffer[l] = c;
    StringBuffer[l + 1] = 0;
}

void DeleteBufferKludge()
{
    yy_delete_buffer(YY_CURRENT_BUFFER);
    YY_CURRENT_BUFFER = 0;
}




