#include "messform.h"
#include "autocharptr.h"
#include <string.h>
#include <assert.h>
#include <stdio.h>

MessageFormat::MessageFormat(const string &templ):
    Template(templ)
{
}

MessageFormat::MessageFormat(const char *templ):
    Template(templ)
{
}

MessageFormat &MessageFormat::operator << (const string &var)
{
    push_back(var);
    return *this;
}

MessageFormat &MessageFormat::operator << (const char *var)
{
    assert(var != NULL);
    return operator << (string(var));
}

MessageFormat &MessageFormat::operator << (int var)
{   char Buf[100];

    sprintf(Buf, "%d", var);
    return operator << (Buf);
}

string MessageFormat::GetMessage()
{   int i;

    int FromLen = Template.length();
    auto_char_ptr From(FromLen + 1);
    memcpy(From, Template.c_str(), FromLen + 1); 

    int VarCount = size();

    int ToSize = FromLen + 1;
    for (i = 0; i < FromLen; ++i)
    {   if (From[i] == '%')
        {   int c = From[i + 1];
            if (c >= '0' && c <= '9')
            {   int j = c - '0';
                if (j < VarCount)
                    ToSize += (this->operator[](j)).size();
            }
            ++ToSize;
            ++i;
        }
    }
    auto_char_ptr To(ToSize);
    char *p = From;
    char *q = To;
    for (i = 0; i < FromLen; ++i)
    {   if (From[i] == '%')
        {   int n = (((char *)From) + i) - p;
	    memcpy(q, p, n);
	    q += n;
	    int c = From[i + 1];
	    if (c >= '0' && c <= '9')
	    {   int j = c - '0';
                if (j < VarCount)
                {   const string &var = this->operator[](j);
                    const char *b = var.begin();
                    memcpy(q, b, var.size());
                    q += var.size();
                    ++i;
                }
                else
                {   *q = '%'; 
                        // return value of GetMessage is *not* used as a format
                        // string - it is printed as string
                    ++q;
                }
            }
            else
            {   *q = '%'; ++q;
                if (c == '%')
                    ++i;
            }
            p = ((char *)From) + i + 1;
        }
    }
    int n = strlen(p);
    memcpy(q, p, n);
    q += n;

    return string((char *)To, q);
}
