#include "linkopt.h"
#if defined(HAVE_CONFIG_H)
#include "config.h"
#endif
#include "olink.h"
#include "omysql.h"

using namespace std;

static TStringCol GetRedirects(const COptions<TStringCol> *options,
    const char *);

CLinkOptions::CLinkOptions()
{
    TStringCol start_url;
    Add(o_start_url, start_url);
    
    TStringCol schemes;
    schemes.push_back(string("http://"));
    Add(o_checked_scheme, schemes);

    TStringCol extensions;
    extensions.push_back(string(".html"));
    extensions.push_back(string(".htm"));
    Add(o_checked_ext, extensions);

    Add(o_paragraph_template, "%0\n referenced from\n%1\n"
	" got status %2 (%3)\n");
    Add(o_paragraph_divider, "\n");
    Add(o_dependency_template, "  %0");
    Add(o_dependency_divider, "\n");

    Add(o_message_pipe, "");

    Add(o_prolog_template, "linkcheck robot, running from %0 to %1,\n"
	"checked %2 and found the following problems:\n\n");
    Add(o_time_template, "%3.%4.%5, %2:%1:%0");
    Add(o_url_template, "%0");
    Add(o_url_divider, ", ");

    COptions<bool>::Add(o_send_ok, false);
    COptions<bool>::Add(o_verbose, false);

    Add(o_ok_template, "Everything is OK; linkcheck robot, running "
	"from %0 to %1,\nchecked %2 and found no problems.");

    Add(o_expected_status, TStringCol());
    Add(o_wild_redirect, TStringCol());
    Add(o_tame_redirect, GetRedirects);

    Add(o_libwww_trace, "");

#if defined(DBSUPP_MYSQL)
    COptions<bool>::Add(o_mysql_support, true);
    Add(o_mysql_host, "localhost");
    Add(o_mysql_user, "linkcheck");
    Add(o_mysql_password, "linkcheck");
    Add(o_mysql_database, "linkcheck");
    Add(o_mysql_links_table, "links");
    Add(o_mysql_links_src_column, "src_url");
    Add(o_mysql_links_dest_column, "dest_url");
    Add(o_mysql_found_urls_table, "found_urls");
    Add(o_mysql_found_urls_url_column, "url");
    Add(o_mysql_found_urls_timestamp, "found");
#endif

    WatchSection("");
}

static TStringCol GetRedirects(const COptions<TStringCol> *options,
    const char *)
{
    TStringCol wild = options->Get(o_wild_redirect);
    if (wild.empty())
	return options->Get(o_start_url);
	    // some people may actually check URLs without knowing
            // they must be redirected
    else
	return wild;
	    // user defined their own redirects - let's suppose
            // they know what they're doing
}
