#include "expstat.h"
#include "linkopt.h"
#include "olink.h"

ExpectedStatus::ExpectedStatus(CLinkOptions &opt)
{
    TStringCol es = opt.Get_TStringCol(o_expected_status);
    for (TStringCol::const_iterator i = es.begin();
	i != es.end();
	++i)
    {   string url;
        short front;
	short back;
	ParseExpectedUrlStatus(*i, url, front, back);
	Map[url] = StatusRange(front, back);
    }
}

bool ExpectedStatus::IsExpectedStatus(const string &uri,
    int status) const
{
    TMap::const_iterator i = Map.find(uri);
    if (i != Map.end())
	return i->second.IsInRange(status);

    return status == 200;
}

