#if !defined(excpt_h)
#define excpt_h

#include <string>

class Exception
{
protected:
    Exception();
public:
    virtual ~Exception();
};

class FileOpenException : public Exception
{
public:
    FileOpenException(const std::string &aFName);

    const std::string FName;
};

class FileParseException : public Exception
{
public:
    FileParseException(const std::string &aFName,
	int aLine,
	const std::string &aMess); // should be replaced by a hierarchy

    const std::string FName;
    const int Line;
    const std::string Mess;
};

class RegexParseException : public Exception
{
public:
    RegexParseException(const std::string &aSource,
	const std::string &aMess);

    const std::string Source;
    const std::string Mess;
};

class DuplicateKeyException : public Exception
{
public:
    DuplicateKeyException(const std::string &aKey);

    const std::string Key;
};

class UndefinedKeyException : public Exception
{
public:
    UndefinedKeyException(const std::string &aKey);

    const std::string Key;
};

class MultipleDefinitionException : public Exception
{
public:
    MultipleDefinitionException(const std::string &aKey);

    const std::string Key;
};

class MissingValueException : public Exception
{
public:
    MissingValueException(const std::string &aKey);

    const std::string Key;
};

#endif
