#if !defined(database_h)
#define database_h

#include <string>
#include <set>

class CLinkOptions;

class DatabaseProtocol
{
public:
    virtual ~DatabaseProtocol();

    virtual bool InsertFound(const std::string &url) = 0;
	// returns true OK, false url already known
    virtual void InsertLink(const std::string &src_url,
	const std::string &dest_url) = 0;
    virtual std::set<std::string> GetDependencies(
	const std::string &url) = 0;
};

class Database : public DatabaseProtocol
{
public:
    Database(CLinkOptions &options);
    Database(const Database &other);
    virtual ~Database();
    Database &operator=(const Database &other);

    virtual bool InsertFound(const std::string &url);
    virtual void InsertLink(const std::string &src_url,
	const std::string &dest_url);
    virtual std::set<std::string> GetDependencies(
	const std::string &url);

private:
    DatabaseProtocol *Impl;
    int *RefCount;

    inline void AddRef() const { ++(*RefCount); }
    void DelRef();
};

class ConnectError
{
public:
    std::string Message;

    ConnectError(const char *msg);
};

class SelectError
{
public:
    std::string DatabaseName;
    std::string Message;
    
    SelectError(const std::string &db_name,
	const std::string &msg);
};

class QueryError
{
public:
    int ErrorNumber;
    std::string Query;
    std::string Message;

    QueryError(int error_number,
	const std::string &query,
	const char *msg);
};

class ResultError
{
public:
    std::string Message;

    ResultError(const char *msg);
};

#endif
