#include "curstate.h"
#include "rferr.h"
#include "paction.h"

#include <string.h>
#include <stdlib.h> /* for malloc & free */

extern void DeleteBufferKludge(void);

static char *CurSect = NULL;
static char *CurKey = NULL;
static SStrList *CurStrList = NULL;

char *InitState()
{
    if ((CurStrList = InitStrList()) == NULL)
        return OE_GENERIC;

    return NULL;	 
}
	   
void DoneState(void)
{
    if (CurSect)
    {	free(CurSect);
        CurSect = NULL;
    }
    if (CurKey)
    {	free(CurKey);
        CurKey = NULL;
    }
    if (CurStrList)
    {	DoneStrList(CurStrList);
        CurStrList = NULL;
    }
//    DeleteBufferKludge();
}

char *SetCurrentSection(char *SectName)
{
    if (CurSect)
	free(CurSect);
    CurSect = AllocMungedSectionName(SectName);
    return NULL;
}

char *GetCurrentSection()
{
    return CurSect;
}
			 
char *SetCurrentKey(char *Key)
{
    if (CurKey)
	free(CurKey);
    CurKey = Key;
    return NULL;
}

char *GetCurrentKey()
{
    return CurKey;
}

SStrList *GetList()
{
    return CurStrList;
}

char *ResetList()
{
    if (CurStrList)
        DoneStrList(CurStrList);
    if ((CurStrList = InitStrList()) == NULL)
        return OE_GENERIC;
    return NULL;	 
}
 
