#if !defined(autocharptr_h)
#define autocharptr_h

#include <string.h> 

class auto_char_ptr
{
public:
    typedef char *pchar;

    inline auto_char_ptr(size_t size);
    inline ~auto_char_ptr();

    operator pchar() { return Data; }
    char &operator[](size_t i) { return Data[i]; }

    size_t GetSize() { return Size; }

private:
    char *Data;
    size_t Size;
};

inline auto_char_ptr::auto_char_ptr(size_t size):
    Size(size),
    Data(new char[size])
{
}

inline auto_char_ptr::~auto_char_ptr()
{
    delete [] Data;
}

#endif
