#if !defined(ancheck_h)
#define ancheck_h

#include "HTMethod.h"
#include <vector>
#include <string>

using namespace std;

class CLinkOptions;

class InvalidUriException
{
public:
    InvalidUriException(const string &uri):Uri(uri) { }

    const string Uri;
};

class AnchorChecker
{
public:
    AnchorChecker(CLinkOptions &opt);

    bool IsInteresting(
	const char *url,
	    // can't be NULL
	HTMethod &method) const;
	    // out param

private:
    vector<string> ShortHeads;
    vector<string> LongHeads;
    vector<string> Tails;

    bool IsTail(const char *p) const;
    static bool HasOneOf(const char *uri,
	const vector<string> &heads);
    static bool HasHead(const char *uri, const char *head);
};

#endif
